/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.repo.search.impl.QueryParserUtils;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.IndexTrackingShutdownException;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerStats;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTracker
implements Tracker {
    static final long TIME_STEP_32_DAYS_IN_MS = 2764800000L;
    static final long TIME_STEP_1_HR_IN_MS = 3600000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTracker.class);
    protected Properties props;
    protected SOLRAPIClient client;
    InformationServer infoSrv;
    protected String coreName;
    StoreRef storeRef;
    long batchCount;
    TrackerStats trackerStats;
    boolean runPostModelLoadInit = true;
    private int maxLiveSearchers;
    private volatile boolean shutdown = false;
    protected volatile TrackerState state;
    protected int shardCount;
    protected int shardInstance;
    ShardMethodEnum shardMethod;
    protected boolean transformContent;
    String shardTemplate;
    protected volatile boolean rollback;
    protected Throwable rollbackCausedBy;
    protected final Tracker.Type type;
    protected final String trackerId;
    DocRouter docRouter;
    protected Optional<QName> shardProperty = Optional.empty();
    protected Optional<String> shardKey;

    protected AbstractTracker(Tracker.Type type) {
        this.type = type;
        this.trackerId = String.valueOf((Object)type) + "@" + this.hashCode();
    }

    protected AbstractTracker(Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer, Tracker.Type type) {
        this.props = p;
        this.client = client;
        this.coreName = coreName;
        this.infoSrv = informationServer;
        this.storeRef = new StoreRef(p.getProperty("alfresco.stores", "workspace://SpacesStore"));
        this.batchCount = Integer.parseInt(p.getProperty("alfresco.batch.count", "5000"));
        this.maxLiveSearchers = Integer.parseInt(p.getProperty("alfresco.maxLiveSearchers", "2"));
        this.shardCount = Integer.parseInt(p.getProperty("shard.count", "1"));
        this.shardInstance = Integer.parseInt(p.getProperty("shard.instance", "0"));
        this.shardMethod = ShardMethodEnum.getShardMethod((String)p.getProperty("shard.method", ShardMethodEnum.DB_ID.name()));
        this.shardTemplate = p.getProperty("alfresco.template", "");
        this.transformContent = Boolean.parseBoolean(p.getProperty("alfresco.index.transformContent", "true"));
        this.trackerStats = this.infoSrv.getTrackerStats();
        this.type = type;
        this.trackerId = String.valueOf((Object)type) + "@" + this.hashCode();
        this.shardKey = Optional.ofNullable(p.getProperty("shard.key"));
        this.firstUpdateShardProperty();
        this.docRouter = DocRouterFactory.getRouter(p, this.shardMethod);
    }

    protected abstract void doTrack(String var1) throws Throwable;

    private boolean assertTrackerStateRemainsNull() {
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getTrackerState();
        return this.state == null;
    }

    @Override
    public void track() {
        block11: {
            String iterationId = "IT #" + System.currentTimeMillis();
            if (this.getRunLock().availablePermits() == 0) {
                LOGGER.info("[{} / {} / {}] Tracker already registered.", new Object[]{this.coreName, this.trackerId, iterationId});
                return;
            }
            try {
                this.getRunLock().acquire();
                if (this.state == null && Boolean.parseBoolean(System.getProperty("alfresco.test", "false"))) assert (this.assertTrackerStateRemainsNull());
                this.updateTrackerState(iterationId);
                this.infoSrv.registerTrackerThread();
                try {
                    this.doTrack(iterationId);
                }
                catch (IndexTrackingShutdownException t) {
                    this.setRollback(true, t);
                    LOGGER.info("[{} / {} / {}] Tracking cycle stopped. See the stacktrace below for further details.", new Object[]{this.coreName, this.trackerId, iterationId, t});
                }
                catch (Throwable t) {
                    this.setRollback(true, t);
                    if (t instanceof SocketTimeoutException || t instanceof ConnectException) {
                        LOGGER.warn("[{} / {} / {}] Tracking communication timed out. See the stacktrace below for further details.", new Object[]{this.coreName, this.trackerId, iterationId});
                        LOGGER.debug("[{} / {} / {}] Stack trace", new Object[]{this.coreName, this.trackerId, iterationId, t});
                        break block11;
                    }
                    LOGGER.error("[{} / {} / {}] Tracking failure. See the stacktrace below for further details.", new Object[]{this.coreName, this.trackerId, iterationId, t});
                }
            }
            catch (Exception exception) {
                LOGGER.error("[{} / {} / {}] Some problem was detected while resetting the Tracker State. See the stracktrace below for further details.", new Object[]{this.coreName, this.trackerId, iterationId, exception});
            }
            finally {
                this.infoSrv.unregisterTrackerThread();
                Optional.ofNullable(this.state).ifPresent(this::turnOff);
                this.getRunLock().release();
            }
        }
    }

    private synchronized void updateTrackerState(String iterationId) {
        if (this.state == null) {
            this.state = this.getTrackerState();
            LOGGER.debug("[{} / {} / {}]  Global Tracker State set to: {}", new Object[]{this.coreName, this.trackerId, iterationId, this.state.toString()});
        } else {
            this.continueState();
        }
        this.state.setRunning(true);
    }

    private void turnOff(TrackerState state) {
        try {
            state.setRunning(false);
            state.setCheck(false);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to properly turn off the TrackerState instance. See the stacktrace below for further details.", (Throwable)exception);
        }
    }

    @Override
    public boolean getRollback() {
        return this.rollback;
    }

    @Override
    public Throwable getRollbackCausedBy() {
        return this.rollbackCausedBy;
    }

    @Override
    public void setRollback(boolean rollback, Throwable rollbackCausedBy) {
        this.rollback = rollback;
        this.rollbackCausedBy = rollbackCausedBy;
    }

    private void continueState() {
        this.infoSrv.continueState(this.state);
        this.state.incrementTrackerCycles();
    }

    @Override
    public synchronized void invalidateState() {
        this.state = null;
    }

    @Override
    public synchronized TrackerState getTrackerState() {
        if (this.state != null) {
            return this.state;
        }
        return this.infoSrv.getTrackerInitialState();
    }

    int getMaxLiveSearchers() {
        return this.maxLiveSearchers;
    }

    void checkShutdown() {
        if (this.shutdown) {
            throw new IndexTrackingShutdownException();
        }
    }

    @Override
    public boolean isAlreadyInShutDownMode() {
        return this.shutdown;
    }

    @Override
    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    @Override
    public void shutdown() {
        this.setShutdown(true);
    }

    @Override
    public abstract Semaphore getWriteLock();

    public abstract Semaphore getRunLock();

    @Override
    public Properties getProps() {
        return this.props;
    }

    @Override
    public Tracker.Type getType() {
        return this.type;
    }

    void updateShardProperty() {
        this.shardKey.ifPresent(shardKeyName -> {
            Optional<QName> updatedShardProperty = AbstractTracker.getShardProperty(shardKeyName);
            if (!this.shardProperty.equals(updatedShardProperty)) {
                if (updatedShardProperty.isEmpty()) {
                    LOGGER.warn("The model defining {} property has been disabled", shardKeyName);
                } else {
                    LOGGER.info("New {} property found for {}", (Object)"shard.key", shardKeyName);
                }
            }
            this.shardProperty = updatedShardProperty;
        });
    }

    static Optional<QName> getShardProperty(String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            throw new IllegalArgumentException("Sharding property shard.key has not been set.");
        }
        AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance();
        NamespaceDAO namespaceDAO = dataModel.getNamespaceDAO();
        DictionaryComponent dictionaryService = dataModel.getDictionaryService("DEFAULT_DICTIONARY");
        PropertyDefinition propertyDef = QueryParserUtils.matchPropertyDefinition((String)"http://www.alfresco.org/model/content/1.0", (NamespacePrefixResolver)namespaceDAO, (DictionaryService)dictionaryService, (String)field);
        return Optional.ofNullable(propertyDef).map(PropertyDefinition::getName);
    }

    public NodeReport checkNode(Long dbid) {
        NodeReport nodeReport = new NodeReport();
        nodeReport.setDbid(dbid);
        this.infoSrv.addCommonNodeReportInfo(nodeReport);
        return nodeReport;
    }

    public DocRouter getDocRouter() {
        return this.docRouter;
    }

    private void firstUpdateShardProperty() {
        this.shardKey.ifPresent(shardKeyName -> {
            this.updateShardProperty();
            if (this.shardProperty.isEmpty()) {
                LOGGER.warn("Sharding property {} was set to {}, but no such property was found.", (Object)"shard.key", shardKeyName);
            }
        });
    }
}

