/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.solr.query.AbsoluteStructuredFieldPosition;
import org.alfresco.solr.query.DescendantAndSelfStructuredFieldPosition;
import org.alfresco.solr.query.RelativeStructuredFieldPosition;
import org.alfresco.solr.query.SelfAxisStructuredFieldPosition;
import org.alfresco.solr.query.SolrPathScorer;
import org.alfresco.solr.query.StructuredFieldPosition;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class SolrPathQuery
extends Query {
    private String pathField = "PATH";
    private int unitSize = 2;
    private List<StructuredFieldPosition> pathStructuredFieldPositions = new ArrayList<StructuredFieldPosition>();
    private DictionaryService dictionaryService;
    private boolean repeats = false;

    public SolrPathQuery(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setQuery(List<StructuredFieldPosition> path) {
        this.pathStructuredFieldPositions.clear();
        if (path.size() % this.unitSize != 0) {
            throw new UnsupportedOperationException();
        }
        this.pathStructuredFieldPositions.addAll(path);
    }

    public void appendQuery(List<StructuredFieldPosition> sfps) {
        if (sfps.size() != this.unitSize) {
            throw new UnsupportedOperationException();
        }
        StructuredFieldPosition last = null;
        StructuredFieldPosition next = sfps.get(0);
        if (this.pathStructuredFieldPositions.size() > 0) {
            last = this.pathStructuredFieldPositions.get(this.pathStructuredFieldPositions.size() - 1);
        }
        if (last != null && next.linkParent() && !last.allowslinkingByParent()) {
            return;
        }
        if (last != null && next.linkSelf() && !last.allowsLinkingBySelf()) {
            return;
        }
        this.pathStructuredFieldPositions.addAll(sfps);
    }

    public String getPathField() {
        return this.pathField;
    }

    public void setPathField(String pathField) {
        this.pathField = pathField;
    }

    public Term getPathRootTerm() {
        return new Term(this.getPathField(), ";");
    }

    ArrayList<Term> getTerms() {
        ArrayList<Term> answer = new ArrayList<Term>(this.pathStructuredFieldPositions.size());
        for (StructuredFieldPosition sfp : this.pathStructuredFieldPositions) {
            if (sfp.getTermText() == null) continue;
            Term term = new Term(this.pathField, sfp.getTermText());
            answer.add(term);
        }
        return answer;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScore) {
        return new StructuredFieldWeight();
    }

    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PATH:");
        for (int i = 0; i < this.pathStructuredFieldPositions.size(); i += 2) {
            if (this.pathStructuredFieldPositions.get(i) instanceof AbsoluteStructuredFieldPosition) {
                stringBuilder.append("/");
                if (this.pathStructuredFieldPositions.get(i).getTermText() == null && this.pathStructuredFieldPositions.get(i + 1).getTermText() == null) {
                    stringBuilder.append("*");
                    continue;
                }
                stringBuilder.append("{");
                stringBuilder.append(this.pathStructuredFieldPositions.get(i).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i).getTermText());
                stringBuilder.append("}:");
                stringBuilder.append(this.pathStructuredFieldPositions.get(i + 1).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i + 1).getTermText());
                continue;
            }
            if (this.pathStructuredFieldPositions.get(i) instanceof DescendantAndSelfStructuredFieldPosition) {
                stringBuilder.append("//");
                continue;
            }
            if (this.pathStructuredFieldPositions.get(i) instanceof RelativeStructuredFieldPosition) {
                stringBuilder.append("/");
                if (this.pathStructuredFieldPositions.get(i).getTermText() == null && this.pathStructuredFieldPositions.get(i + 1).getTermText() == null) {
                    stringBuilder.append("*");
                    continue;
                }
                stringBuilder.append(this.pathStructuredFieldPositions.get(i).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i).getTermText());
                stringBuilder.append(":");
                stringBuilder.append(this.pathStructuredFieldPositions.get(i + 1).getTermText() == null ? "*" : this.pathStructuredFieldPositions.get(i + 1).getTermText());
                continue;
            }
            if (!(this.pathStructuredFieldPositions.get(i) instanceof SelfAxisStructuredFieldPosition)) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public void removeDescendantAndSelf() {
        while (this.getLast() != null && this.getLast().linkSelf()) {
            this.removeLast();
            this.removeLast();
        }
    }

    private StructuredFieldPosition getLast() {
        if (this.pathStructuredFieldPositions.size() > 0) {
            return this.pathStructuredFieldPositions.get(this.pathStructuredFieldPositions.size() - 1);
        }
        return null;
    }

    private void removeLast() {
        this.pathStructuredFieldPositions.remove(this.pathStructuredFieldPositions.size() - 1);
    }

    public boolean isEmpty() {
        return this.pathStructuredFieldPositions.size() == 0;
    }

    public List<StructuredFieldPosition> getPathStructuredFieldPositions() {
        return this.pathStructuredFieldPositions;
    }

    public void setRepeats(boolean repeats) {
        this.repeats = repeats;
    }

    public int hashCode() {
        int result = this.pathField != null ? this.pathField.hashCode() : 0;
        result = 31 * result + this.unitSize;
        result = 31 * result + (this.pathStructuredFieldPositions != null ? this.pathStructuredFieldPositions.hashCode() : 0);
        result = 31 * result + (this.repeats ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SolrPathQuery other = (SolrPathQuery)((Object)obj);
        if (this.pathField == null ? other.pathField != null : !this.pathField.equals(other.pathField)) {
            return false;
        }
        if (this.pathStructuredFieldPositions == null ? other.pathStructuredFieldPositions != null : !this.pathStructuredFieldPositions.equals(other.pathStructuredFieldPositions)) {
            return false;
        }
        if (this.repeats != other.repeats) {
            return false;
        }
        return this.unitSize == other.unitSize;
    }

    private class StructuredFieldWeight
    extends Weight {
        public StructuredFieldWeight() {
            super((Query)SolrPathQuery.this);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public float getValueForNormalization() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return SolrPathScorer.createPathScorer(SolrPathQuery.this, context, this, SolrPathQuery.this.dictionaryService, SolrPathQuery.this.repeats);
        }

        public void extractTerms(Set<Term> terms) {
            throw new UnsupportedOperationException();
        }
    }
}

