/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.AbstractQParser;
import org.alfresco.util.Pair;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisQParserPlugin
extends QParserPlugin {
    protected static final Logger log = LoggerFactory.getLogger(CmisQParserPlugin.class);
    private NamedList<Object> args;

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new CmisQParser(qstr, localParams, params, req, this.args);
    }

    public void init(NamedList args) {
        this.args = args;
    }

    public static class CmisQParser
    extends AbstractQParser {
        public CmisQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, NamedList<Object> args) {
            super(qstr, localParams, params, req, args);
        }

        public org.apache.lucene.search.Query parse() throws SyntaxError {
            try {
                Pair<SearchParameters, Boolean> searchParametersAndFilter = this.getSearchParameters();
                SearchParameters searchParameters = (SearchParameters)searchParametersAndFilter.getFirst();
                String cmisVersionString = this.params.get("cmisVersion");
                CmisVersion cmisVersion = cmisVersionString == null ? CmisVersion.CMIS_1_0 : CmisVersion.valueOf((String)cmisVersionString);
                String altDic = this.params.get("alternativeDic");
                Query queryModelQuery = AlfrescoSolrDataModel.getInstance().parseCMISQueryToAlfrescoAbstractQuery(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, searchParameters, this.req, altDic, cmisVersion);
                if (queryModelQuery.getOrderings() != null && queryModelQuery.getOrderings().size() > 0) {
                    StringBuilder sortParameter = new StringBuilder();
                    for (Ordering ordering : queryModelQuery.getOrderings()) {
                        if (ordering.getColumn().getFunction().getName().equals("PropertyAccessor")) {
                            PropertyArgument property = (PropertyArgument)ordering.getColumn().getFunctionArguments().get("Property");
                            if (property == null) {
                                throw new IllegalStateException();
                            }
                            String propertyName = property.getPropertyName();
                            String luceneField = AlfrescoSolrDataModel.getInstance().getCMISFunctionEvaluationContext(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, cmisVersion, altDic).getLuceneFieldName(propertyName);
                            if (sortParameter.length() > 0) {
                                sortParameter.append(", ");
                            }
                            sortParameter.append(luceneField).append(" ");
                            if (ordering.getOrder() == Order.DESCENDING) {
                                sortParameter.append("desc");
                                continue;
                            }
                            sortParameter.append("asc");
                            continue;
                        }
                        if (ordering.getColumn().getFunction().getName().equals("Score")) {
                            if (sortParameter.length() > 0) {
                                sortParameter.append(", ");
                            }
                            sortParameter.append("SCORE ");
                            if (ordering.getOrder() == Order.DESCENDING) {
                                sortParameter.append("desc");
                                continue;
                            }
                            sortParameter.append("asc");
                            continue;
                        }
                        throw new IllegalStateException();
                    }
                    ModifiableSolrParams newParams = new ModifiableSolrParams(this.req.getParams());
                    newParams.set("sort", new String[]{sortParameter.toString()});
                    this.req.setParams((SolrParams)newParams);
                    this.params = newParams;
                }
                org.apache.lucene.search.Query query = AlfrescoSolrDataModel.getInstance().getCMISQuery(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS, searchParametersAndFilter, this.req, queryModelQuery, cmisVersion, altDic);
                if (log.isDebugEnabled()) {
                    log.debug("AFTS QP query as lucene:\t    " + String.valueOf(query));
                }
                return query;
            }
            catch (ParseException e) {
                throw new SyntaxError((Throwable)e);
            }
        }
    }
}

