/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.stream.LongStream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class AbstractSolrCachingScorer
extends Scorer {
    SolrCachingScorerDoIdSetIterator iterator;

    protected static Long getLong(long l) {
        if (l > (long)LongCache.CACHE_SIZE) {
            return l;
        }
        return LongCache.cache[(int)l];
    }

    AbstractSolrCachingScorer(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight);
        this.iterator = new SolrCachingScorerDoIdSetIterator(in, context, searcher);
    }

    public float score() throws IOException {
        return 1.0f;
    }

    public int freq() throws IOException {
        return 1;
    }

    public int docID() {
        return this.iterator.docID();
    }

    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    protected static class LongCache {
        private static int CACHE_SIZE = 1000000;
        static final long[] cache = LongStream.range(0L, CACHE_SIZE).toArray();

        private LongCache() {
        }
    }

    private static class SolrCachingScorerDoIdSetIterator
    extends DocIdSetIterator {
        BitDocSet matches;
        int doc = -1;
        FixedBitSet bitSet;
        LeafReaderContext context;

        SolrCachingScorerDoIdSetIterator(DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
            this.context = context;
            if (in instanceof BitDocSet) {
                this.matches = (BitDocSet)in;
            } else {
                this.matches = new BitDocSet(new FixedBitSet(searcher.maxDoc()));
                DocIterator it = in.iterator();
                while (it.hasNext()) {
                    this.matches.addUnique(it.nextDoc());
                }
            }
            this.bitSet = this.matches.getBits();
            this.doc = this.getBase() - 1;
        }

        private boolean next() {
            if (this.doc + 1 < this.bitSet.length()) {
                this.doc = this.bitSet.nextSetBit(this.doc + 1);
                return this.doc != Integer.MAX_VALUE && this.doc < this.getBase() + this.context.reader().maxDoc();
            }
            return false;
        }

        private int getBase() {
            return this.context.docBase;
        }

        public int nextDoc() throws IOException {
            if (this.next()) {
                return this.docID();
            }
            return Integer.MAX_VALUE;
        }

        public int docID() {
            if (this.doc > -1 && this.doc != Integer.MAX_VALUE) {
                return this.doc - this.getBase();
            }
            return this.doc;
        }

        public int advance(int target) throws IOException {
            while (this.next()) {
                int current = this.docID();
                if (current < target) continue;
                return current;
            }
            return Integer.MAX_VALUE;
        }

        public long cost() {
            return 1L;
        }
    }
}

