/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.exec;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.exec.ExecParameterTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuntimeExec {
    public static final String KEY_OS_DEFAULT = "*";
    private static final String KEY_OS_NAME = "os.name";
    private static final int BUFFER_SIZE = 1024;
    private static final String VAR_OPEN = "${";
    private static final String VAR_CLOSE = "}";
    private static final String DIRECTIVE_SPLIT = "SPLIT:";
    private static Log logger = LogFactory.getLog(RuntimeExec.class);
    private static Log transformerDebugLogger = LogFactory.getLog((String)"org.alfresco.repo.content.transform.TransformerDebug");
    private String[] command;
    private Charset charset;
    private boolean waitForCompletion = true;
    private Map<String, String> defaultProperties;
    private String[] processProperties = null;
    private File processDirectory = null;
    private Set<Integer> errCodes;
    private Timer timer = new Timer(true);

    public RuntimeExec() {
        this.charset = Charset.defaultCharset();
        this.defaultProperties = Collections.emptyMap();
        this.errCodes = new HashSet<Integer>(2);
        this.errCodes.add(1);
        this.errCodes.add(2);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("RuntimeExec:\n").append("   command:    ");
        if (this.command == null) {
            sb.append("'null'\n");
        } else {
            for (String cmdStr : this.command) {
                sb.append(cmdStr).append(" ");
            }
            sb.append("\n");
        }
        sb.append("   env props:  ").append(Arrays.toString(this.processProperties)).append("\n").append("   dir:        ").append(this.processDirectory).append("\n").append("   os:         ").append(System.getProperty(KEY_OS_NAME)).append("\n");
        return sb.toString();
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public void setCharset(String charsetCode) {
        this.charset = Charset.forName(charsetCode);
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public void setCommandsAndArguments(Map<String, String[]> commandsByOS) {
        String serverOs = System.getProperty(KEY_OS_NAME);
        String[] command = commandsByOS.get(serverOs);
        if (command == null) {
            for (String osName : commandsByOS.keySet()) {
                if (osName.equals(KEY_OS_DEFAULT) || !serverOs.matches(osName)) continue;
                command = commandsByOS.get(osName);
                break;
            }
            if (command == null) {
                command = commandsByOS.get(KEY_OS_DEFAULT);
            }
        }
        if (command == null) {
            throw new AlfrescoRuntimeException("No command found for OS " + serverOs + " or '*': \n   commands: " + commandsByOS);
        }
        this.command = command;
    }

    public void setCommandMap(Map<String, String> commandsByOS) {
        logger.warn((Object)"The bean RuntimeExec property 'commandMap' has been deprecated; use 'commandsAndArguments' instead.  See https://issues.alfresco.com/jira/browse/ETHREEOH-579.");
        LinkedHashMap<String, String[]> fixed = new LinkedHashMap<String, String[]>(7);
        for (Map.Entry<String, String> entry : commandsByOS.entrySet()) {
            String os = entry.getKey();
            String unparsedCmd = entry.getValue();
            StringTokenizer tokenizer = new StringTokenizer(unparsedCmd);
            String[] cmd = new String[tokenizer.countTokens()];
            for (int i = 0; i < cmd.length; ++i) {
                cmd[i] = tokenizer.nextToken();
            }
            fixed.put(os, cmd);
        }
        this.setCommandsAndArguments(fixed);
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setProcessProperties(Map<String, String> processProperties) {
        ArrayList<CallSite> processPropList = new ArrayList<CallSite>(processProperties.size());
        boolean hasPath = false;
        String systemPath = System.getenv("PATH");
        for (Map.Entry<String, String> entry : processProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null) continue;
            if (value == null) {
                value = "";
            }
            key = key.trim();
            value = value.trim();
            if (key.startsWith(VAR_OPEN) && key.endsWith(VAR_CLOSE) || value.startsWith(VAR_OPEN) && value.endsWith(VAR_CLOSE)) continue;
            if (key.equals("PATH")) {
                if (systemPath != null && systemPath.length() > 0) {
                    processPropList.add((CallSite)((Object)(key + "=" + value + File.pathSeparator + systemPath)));
                } else {
                    processPropList.add((CallSite)((Object)(key + "=" + value)));
                }
                hasPath = true;
                continue;
            }
            processPropList.add((CallSite)((Object)(key + "=" + value)));
        }
        if (!hasPath && systemPath != null && systemPath.length() > 0) {
            processPropList.add((CallSite)((Object)("PATH=" + systemPath)));
        }
        this.processProperties = processPropList.toArray(new String[processPropList.size()]);
    }

    public void setProcessProperty(String name, String value) {
        boolean set = false;
        if (name == null || value == null) {
            return;
        }
        name = name.trim();
        value = value.trim();
        if (name.isEmpty() || value.isEmpty()) {
            return;
        }
        String property = name + "=" + value;
        for (String prop : this.processProperties) {
            if (prop.equals(property)) {
                set = true;
                break;
            }
            if (!prop.startsWith(name)) continue;
            String oldValue = prop.split("=")[1];
            prop.replace(oldValue, value);
            set = true;
        }
        if (!set) {
            String[] existedProperties = this.processProperties;
            int epl = existedProperties.length;
            String[] newProperties = Arrays.copyOf(existedProperties, epl + 1);
            newProperties[epl] = property;
            this.processProperties = newProperties;
            set = true;
        }
    }

    public void setProcessDirectory(String processDirectory) {
        if (processDirectory.startsWith(VAR_OPEN) && processDirectory.endsWith(VAR_CLOSE)) {
            this.processDirectory = null;
        } else {
            this.processDirectory = new File(processDirectory);
            if (!this.processDirectory.exists()) {
                logger.warn((Object)("The runtime process directory is not visible when setting property 'processDirectory': \n" + this));
            }
        }
    }

    public void setErrorCodes(String errCodesStr) {
        this.errCodes.clear();
        StringTokenizer tokenizer = new StringTokenizer(errCodesStr, " ,");
        while (tokenizer.hasMoreElements()) {
            String errCodeStr = tokenizer.nextToken();
            try {
                int errCode = Integer.parseInt(errCodeStr);
                this.errCodes.add(errCode);
            }
            catch (NumberFormatException e) {
                throw new AlfrescoRuntimeException("Property 'errorCodes' must be comma-separated list of integers: " + errCodesStr);
            }
        }
    }

    public ExecutionResult execute() {
        return this.execute(this.defaultProperties);
    }

    public ExecutionResult execute(Map<String, String> properties) {
        return this.execute(properties, -1L);
    }

    public ExecutionResult execute(Map<String, String> properties, final long timeoutMs) {
        int defaultFailureExitValue;
        int n = defaultFailureExitValue = this.errCodes.size() > 0 ? (Integer)this.errCodes.toArray()[0] : 1;
        if (this.command == null) {
            throw new AlfrescoRuntimeException("Runtime command has not been set: \n" + this);
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String[] commandToExecute = null;
        try {
            Process thisProcess;
            commandToExecute = this.getCommand(properties);
            process = thisProcess = runtime.exec(commandToExecute, this.processProperties, this.processDirectory);
            if (timeoutMs > 0L) {
                final String[] command = commandToExecute;
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            thisProcess.exitValue();
                        }
                        catch (IllegalThreadStateException stillRunning) {
                            if (transformerDebugLogger.isDebugEnabled()) {
                                transformerDebugLogger.debug((Object)("Process has taken too long (" + timeoutMs / 1000L + " seconds). Killing process " + Arrays.deepToString(command)));
                            }
                            thisProcess.destroy();
                        }
                    }
                }, timeoutMs);
            }
        }
        catch (IOException e) {
            String execOut = "";
            String execErr = e.getMessage();
            int exitValue = defaultFailureExitValue;
            ExecutionResult result = new ExecutionResult(null, commandToExecute, this.errCodes, exitValue, execOut, execErr);
            this.logFullEnvironmentDump(result);
            return result;
        }
        InputStreamReaderThread stdOutGobbler = new InputStreamReaderThread(process.getInputStream(), this.charset);
        InputStreamReaderThread stdErrGobbler = new InputStreamReaderThread(process.getErrorStream(), this.charset);
        stdOutGobbler.start();
        stdErrGobbler.start();
        int exitValue = 0;
        try {
            if (this.waitForCompletion) {
                exitValue = process.waitFor();
            }
        }
        catch (InterruptedException e) {
            stdErrGobbler.addToBuffer(e.toString());
            exitValue = defaultFailureExitValue;
        }
        if (this.waitForCompletion) {
            stdOutGobbler.waitForCompletion();
            stdErrGobbler.waitForCompletion();
        }
        String execOut = stdOutGobbler.getBuffer();
        String execErr = stdErrGobbler.getBuffer();
        ExecutionResult result = new ExecutionResult(process, commandToExecute, this.errCodes, exitValue, execOut, execErr);
        this.logFullEnvironmentDump(result);
        return result;
    }

    private void logFullEnvironmentDump(ExecutionResult result) {
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(result);
            if (this.processProperties != null && this.processProperties.length > 0) {
                sb.append("\n   modified environment: ");
                for (int i = 0; i < this.processProperties.length; ++i) {
                    String property = this.processProperties[i];
                    sb.append("\n        ");
                    sb.append(property);
                }
            }
            sb.append("\n   existing environment: ");
            Map<String, String> envVariables = System.getenv();
            for (Map.Entry<String, String> entry : envVariables.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                sb.append("\n        ");
                sb.append(name + "=" + value);
            }
            logger.trace((Object)sb);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)result);
        }
    }

    public String[] getCommand() {
        return this.getCommand(this.defaultProperties);
    }

    public String[] getCommand(Map<String, String> properties) {
        Map<String, String> execProperties = null;
        if (properties == this.defaultProperties) {
            execProperties = this.defaultProperties;
        } else {
            execProperties = new HashMap<String, String>(this.defaultProperties);
            execProperties.putAll(properties);
        }
        ArrayList<String> adjustedCommandElements = new ArrayList<String>(20);
        for (int i = 0; i < this.command.length; ++i) {
            StringBuilder sb = new StringBuilder(this.command[i]);
            for (Map.Entry<String, String> entry : execProperties.entrySet()) {
                Object key = entry.getKey();
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                key = VAR_OPEN + (String)key + VAR_CLOSE;
                int index = sb.indexOf((String)key);
                while (index > -1) {
                    sb.replace(index, index + ((String)key).length(), value);
                    index = sb.indexOf((String)key, index + 1);
                }
            }
            String adjustedValue = sb.toString();
            if (adjustedValue.startsWith(DIRECTIVE_SPLIT)) {
                String unsplitAdjustedValue = sb.substring(DIRECTIVE_SPLIT.length());
                ExecParameterTokenizer quoteAwareTokenizer = new ExecParameterTokenizer(unsplitAdjustedValue);
                List<String> tokens = quoteAwareTokenizer.getAllTokens();
                adjustedCommandElements.addAll(tokens);
                continue;
            }
            adjustedCommandElements.add(adjustedValue);
        }
        return adjustedCommandElements.toArray(new String[adjustedCommandElements.size()]);
    }

    public static class ExecutionResult {
        private final Process process;
        private final String[] command;
        private final Set<Integer> errCodes;
        private final int exitValue;
        private final String stdOut;
        private final String stdErr;

        private ExecutionResult(Process process, String[] command, Set<Integer> errCodes, int exitValue, String stdOut, String stdErr) {
            this.process = process;
            this.command = command;
            this.errCodes = errCodes;
            this.exitValue = exitValue;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
        }

        public String toString() {
            String out = this.stdOut.length() > 250 ? this.stdOut.substring(0, 250) : this.stdOut;
            String err = this.stdErr.length() > 250 ? this.stdErr.substring(0, 250) : this.stdErr;
            StringBuilder sb = new StringBuilder(128);
            sb.append("Execution result: \n").append("   os:         ").append(System.getProperty(RuntimeExec.KEY_OS_NAME)).append("\n").append("   command:    ");
            this.appendCommand(sb, this.command).append("\n").append("   succeeded:  ").append(this.getSuccess()).append("\n").append("   exit code:  ").append(this.exitValue).append("\n").append("   out:        ").append(out).append("\n").append("   err:        ").append(err);
            return sb.toString();
        }

        private StringBuilder appendCommand(StringBuilder sb, String[] command) {
            boolean arg = false;
            for (String element : command) {
                boolean escape;
                if (element == null) continue;
                if (arg) {
                    sb.append(' ');
                } else {
                    arg = true;
                }
                boolean bl = escape = element.indexOf(32) != -1 || element.indexOf(62) != -1;
                if (escape) {
                    sb.append("\"");
                }
                sb.append(element);
                if (!escape) continue;
                sb.append("\"");
            }
            return sb;
        }

        public boolean killProcess() {
            if (this.process == null) {
                return true;
            }
            try {
                this.process.destroy();
                return true;
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage());
                return false;
            }
        }

        private boolean isFailureCode(int exitValue) {
            return this.errCodes.contains(exitValue);
        }

        public boolean getSuccess() {
            return !this.isFailureCode(this.exitValue);
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public String getStdOut() {
            return this.stdOut;
        }

        public String getStdErr() {
            return this.stdErr;
        }
    }

    public static class InputStreamReaderThread
    extends Thread {
        private final InputStream is;
        private final Charset charset;
        private final StringBuffer buffer;
        private boolean completed;

        public InputStreamReaderThread(InputStream is, Charset charset) {
            this.setDaemon(true);
            this.is = is;
            this.charset = charset;
            this.buffer = new StringBuffer(1024);
            this.completed = false;
        }

        @Override
        public synchronized void run() {
            this.completed = false;
            byte[] bytes = new byte[1024];
            BufferedInputStream tempIs = null;
            try {
                tempIs = new BufferedInputStream(this.is, 1024);
                int count = -2;
                while (count != -1) {
                    if (count > 0) {
                        String toWrite = new String(bytes, 0, count, this.charset.name());
                        this.buffer.append(toWrite);
                    }
                    count = ((InputStream)tempIs).read(bytes);
                }
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Unable to read stream", e);
            }
            finally {
                if (tempIs != null) {
                    try {
                        ((InputStream)tempIs).close();
                    }
                    catch (Exception exception) {}
                }
                this.completed = true;
                this.notifyAll();
            }
        }

        public synchronized void waitForCompletion() {
            while (!this.completed) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void addToBuffer(String msg) {
            this.buffer.append(msg);
        }

        public boolean isComplete() {
            return this.completed;
        }

        public String getBuffer() {
            return this.buffer.toString();
        }
    }
}

