/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util;

import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Class<?> classForName(String clazzName) throws ClassNotFoundException {
        return ReflectionUtils.classForName(clazzName, true);
    }

    public static Class<?> classForName(String clazzName, boolean logWarning) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                return Class.forName(clazzName, true, cl);
            }
        }
        catch (SecurityException e) {
            if (logWarning) {
                LoggerFactory.getLogger(ReflectionUtils.class).warn("Could not access CCL.", (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            return Class.forName(clazzName, true, ReflectionUtils.class.getClassLoader());
        }
        catch (Exception e) {
            if (logWarning) {
                LoggerFactory.getLogger(ReflectionUtils.class).warn("Could not load class: " + clazzName + " (" + e.getMessage() + ").", (Throwable)e);
            }
            throw e;
        }
    }
}

