/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.Map;
import org.alfresco.repo.dictionary.AbstractDictionaryRegistry;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.service.namespace.QName;

public class CoreDictionaryRegistryImpl
extends AbstractDictionaryRegistry {
    public CoreDictionaryRegistryImpl(DictionaryDAO dictionaryDAO) {
        super(dictionaryDAO);
    }

    @Override
    public String getTenantDomain() {
        return null;
    }

    @Override
    protected void initImpl() {
        long startTime = System.currentTimeMillis();
        for (DictionaryListener dictionaryDeployer : this.dictionaryDAO.getDictionaryListeners()) {
            dictionaryDeployer.onDictionaryInit();
        }
        if (logger.isInfoEnabled()) {
            Map<QName, CompiledModel> models = this.getCompiledModels(false);
            logger.info((Object)("Init core dictionary: model count = " + (models != null ? models.size() : 0) + " in " + (System.currentTimeMillis() - startTime) + " msecs [" + Thread.currentThread() + "]"));
        }
    }

    @Override
    public void remove() {
        for (DictionaryListener listener : this.dictionaryDAO.getDictionaryListeners()) {
            listener.afterDictionaryDestroy();
        }
    }

    @Override
    protected QName putModelImpl(CompiledModel model) {
        QName qname = super.putModelImpl(model);
        return qname;
    }

    @Override
    public void removeImpl() {
        for (DictionaryListener listener : this.dictionaryDAO.getDictionaryListeners()) {
            listener.afterDictionaryDestroy();
        }
    }
}

