/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.util.List;
import org.alfresco.repo.action.CommonResourceAbstractBase;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class RuleTypeImpl
extends CommonResourceAbstractBase
implements RuleType {
    private static Log logger = LogFactory.getLog(RuleTypeImpl.class);
    private RuleService ruleService;
    private NodeService nodeService;

    public RuleTypeImpl(List<RuleTrigger> ruleTriggers) {
        if (ruleTriggers != null) {
            for (RuleTrigger trigger : ruleTriggers) {
                trigger.registerRuleType(this);
            }
        }
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        ((RuntimeRuleService)((Object)this.ruleService)).registerRuleType(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayLabel() {
        return I18NUtil.getMessage((String)(this.name + ".display-label"));
    }

    @Override
    public void triggerRuleType(NodeRef nodeRef, NodeRef actionedUponNodeRef, boolean executeRuleImmediately) {
        if (this.ruleService.isEnabled() && this.nodeService.exists(actionedUponNodeRef) && this.ruleService.isRuleTypeEnabled(this.getName())) {
            List<Rule> rules = this.ruleService.getRules(nodeRef, true, this.name);
            String ruleContext = null;
            if (logger.isDebugEnabled() && actionedUponNodeRef != null) {
                ruleContext = (executeRuleImmediately ? " now" : "    ") + " on " + this.nodeService.getPath(actionedUponNodeRef).toString().replaceAll("\\{[^}]*}", "");
            }
            if (rules.size() != 0) {
                for (Rule rule : rules) {
                    boolean exists;
                    if (logger.isDebugEnabled() && nodeRef != null) {
                        ruleContext = " " + rule.getTitle() + ruleContext;
                    }
                    if ((exists = this.nodeService.exists(rule.getNodeRef())) && !rule.getRuleDisabled() && this.ruleService.rulesEnabled(this.ruleService.getOwningNodeRef(rule))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Triggering rule" + ruleContext));
                        }
                        if (!executeRuleImmediately) {
                            ((RuntimeRuleService)((Object)this.ruleService)).addRulePendingExecution(nodeRef, actionedUponNodeRef, rule);
                            continue;
                        }
                        ((RuntimeRuleService)((Object)this.ruleService)).executeRule(rule, actionedUponNodeRef, null);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    String message = null;
                    message = exists ? "Disabled rule " + ruleContext : "Rule " + String.valueOf(rule.getNodeRef()) + "no longer exist";
                    logger.debug((Object)message);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("No rules to trigger" + ruleContext));
            }
        }
    }
}

