/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UpdateTagScopesQuartzJob
implements Job {
    private static Log logger = LogFactory.getLog(UpdateTagScopesQuartzJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        Object actionServiceO = jobData.get((Object)"actionService");
        if (actionServiceO == null || !(actionServiceO instanceof ActionService)) {
            throw new AlfrescoRuntimeException("UpdateTagScopesQuartzJob data must contain a valid 'actionService' reference");
        }
        Object transactionServiceO = jobData.get((Object)"transactionService");
        if (transactionServiceO == null || !(transactionServiceO instanceof TransactionService)) {
            throw new AlfrescoRuntimeException("UpdateTagScopesQuartzJob data must contain a valid 'transactionService' reference");
        }
        Object updateTagsActionO = jobData.get((Object)"updateTagsAction");
        if (updateTagsActionO == null || !(updateTagsActionO instanceof UpdateTagScopesActionExecuter)) {
            throw new AlfrescoRuntimeException("UpdateTagScopesQuartzJob data must contain a valid 'updateTagsAction' reference");
        }
        ActionService actionService = (ActionService)actionServiceO;
        TransactionService transactionService = (TransactionService)transactionServiceO;
        UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)updateTagsActionO;
        if (transactionService.isReadOnly()) {
            logger.info((Object)"Skipping Tag Scopes scheduled update as the system is Read Only");
            return;
        }
        this.execute(actionService, updateTagsAction);
    }

    protected void execute(ActionService actionService, final UpdateTagScopesActionExecuter updateTagsAction) {
        final ArrayList tagNodes = new ArrayList();
        HashSet handledTagNodes = new HashSet();
        while (true) {
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    tagNodes.clear();
                    tagNodes.addAll(updateTagsAction.searchForTagScopesPendingUpdates());
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            Iterator it = tagNodes.iterator();
            while (it.hasNext()) {
                NodeRef nodeRef = (NodeRef)it.next();
                if (!handledTagNodes.contains(nodeRef)) continue;
                it.remove();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Tag scope " + String.valueOf(nodeRef) + " must be being processed by another Thread, not updating it"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Checked for tag scopes with pending tag updates, found " + String.valueOf(tagNodes)));
            }
            if (tagNodes.size() == 0) break;
            Action action = actionService.createAction("update-tagscope");
            action.setParameterValue("tag_scopes", tagNodes);
            actionService.executeAction(action, null, false, false);
            handledTagNodes.addAll(tagNodes);
        }
    }
}

