/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.permissions.AclCrudDAO;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryEngine;
import org.alfresco.repo.search.impl.querymodel.impl.db.NodePermissionAssessor;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class NodePermissionAssessorLimitsTest {
    private NodePermissionAssessor assessor;
    private Node node;

    @Before
    public void setup() {
        this.node = (Node)Mockito.mock(Node.class);
        this.assessor = this.createAssessor();
    }

    @Test
    public void shouldNotQuitAssessingPermissionsWhenMaxPermissionChecksLimitIsNotReached() {
        this.assessor.setMaxPermissionChecks(5);
        this.performChecks(3);
        Assert.assertFalse((boolean)this.assessor.shouldQuitChecks());
        ((NodePermissionAssessor)Mockito.verify((Object)this.assessor, (VerificationMode)Mockito.times((int)3))).isReallyIncluded(this.node);
    }

    @Test
    public void shouldQuitAssessingPermissionsWhenMaxPermissionChecksLimitIsReached() {
        this.assessor.setMaxPermissionChecks(5);
        this.performChecks(20);
        Assert.assertTrue((boolean)this.assessor.shouldQuitChecks());
    }

    @Test
    public void shouldNotAssessPermissionsWhenMaxPermissionCheckTimeIsUp() throws Exception {
        this.assessor.setMaxPermissionCheckTimeMillis(100L);
        this.assessor.isIncluded(this.node);
        Thread.sleep(200L);
        Assert.assertTrue((boolean)this.assessor.shouldQuitChecks());
        ((NodePermissionAssessor)Mockito.verify((Object)this.assessor)).isReallyIncluded(this.node);
    }

    @Test
    public void shouldAssessPermissionsWhenMaxPermissionCheckTimeIsNotUp() throws Exception {
        this.assessor.setMaxPermissionCheckTimeMillis(500L);
        Thread.sleep(200L);
        this.assessor.isIncluded(this.node);
        Assert.assertFalse((boolean)this.assessor.shouldQuitChecks());
        ((NodePermissionAssessor)Mockito.verify((Object)this.assessor, (VerificationMode)Mockito.atLeastOnce())).isReallyIncluded(this.node);
    }

    private void performChecks(int checks) {
        int i = 0;
        while (i < checks) {
            this.assessor.isIncluded(this.node);
            ++i;
        }
    }

    private NodePermissionAssessor createAssessor() {
        AclCrudDAO aclCrudDAO = (AclCrudDAO)Mockito.mock(AclCrudDAO.class);
        PermissionService permissionService = (PermissionService)Mockito.mock(PermissionService.class);
        DBQueryEngine engine = new DBQueryEngine();
        engine.setPermissionService(permissionService);
        engine.setAclCrudDAO(aclCrudDAO);
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        Authority authority = (Authority)Mockito.mock(Authority.class);
        EntityLookupCache nodeCache = (EntityLookupCache)Mockito.mock(EntityLookupCache.class);
        NodePermissionAssessor assessor = (NodePermissionAssessor)Mockito.spy((Object)new NodePermissionAssessor(nodeService, permissionService, authority, nodeCache));
        ((NodePermissionAssessor)Mockito.doReturn((Object)true).when((Object)assessor)).isReallyIncluded((Node)ArgumentMatchers.any(Node.class));
        return assessor;
    }
}

