/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtractorPropertyMappingOverride;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class RFC822MetadataExtracter
extends AbstractMappingMetadataExtracter
implements MetadataExtractorPropertyMappingOverride {
    static String RM_URI = "http://www.alfresco.org/model/recordsmanagement/1.0";
    static String DOD_URI = "http://www.alfresco.org/model/dod5015/1.0";
    static final String RECORD = "record";
    static final String DOD_5015_RECORD = "dod5015record";
    static final QName ASPECT_RECORD = QName.createQName((String)RM_URI, (String)"record");
    static final QName ASPECT_DOD_5015_RECORD = QName.createQName((String)DOD_URI, (String)"dod5015record");
    private static Log logger = LogFactory.getLog(RFC822MetadataExtracter.class);
    private static final HashSet<String> SUPPORTED_MIMETYPES = new HashSet<String>(Arrays.asList("message/rfc822"));
    private NodeService nodeService;

    public RFC822MetadataExtracter() {
        super(SUPPORTED_MIMETYPES);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        logger.error((Object)"RFC822MetadataExtracter.extractRaw should not have been called, as the extraction should have taken place in a T-Engine.");
        return Collections.emptyMap();
    }

    public final Map<String, Set<QName>> getCurrentMapping() {
        return super.getMapping();
    }

    @Override
    public boolean match(String sourceMimetype) {
        return SUPPORTED_MIMETYPES.contains(sourceMimetype) && this.getClass() != RFC822MetadataExtracter.class;
    }

    @Override
    public Map<String, Set<String>> getExtractMapping(NodeRef nodeRef) {
        Map<String, Set<QName>> customMapping = this.getMapping();
        HashMap<String, Set<String>> mapping = new HashMap<String, Set<String>>(customMapping.size());
        boolean isARecord = this.nodeService.hasAspect(nodeRef, ASPECT_RECORD);
        boolean isADodRecord = this.nodeService.hasAspect(nodeRef, ASPECT_DOD_5015_RECORD);
        for (Map.Entry<String, Set<QName>> entry : customMapping.entrySet()) {
            Set<QName> customSystemProperties = entry.getValue();
            HashSet<String> systemProperties = new HashSet<String>(customSystemProperties.size());
            String documentProperty = entry.getKey();
            for (QName customSystemProperty : customSystemProperties) {
                String uri = customSystemProperty.getNamespaceURI();
                boolean rmProperty = RM_URI.equals(uri);
                boolean dodProperty = DOD_URI.equals(uri);
                if (!(rmProperty && isARecord || dodProperty && isADodRecord) && (rmProperty || dodProperty)) continue;
                systemProperties.add(customSystemProperty.toString());
            }
            if (systemProperties.isEmpty()) continue;
            mapping.put(documentProperty, systemProperties);
        }
        return mapping;
    }
}

