/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.util.Pair;

public class SolrFacetComparator
implements Comparator<SolrFacetProperties> {
    private final List<String> sortedIDs = new ArrayList<String>();

    public SolrFacetComparator(List<String> sortedIDs) {
        if (sortedIDs != null) {
            this.sortedIDs.addAll(sortedIDs);
        }
    }

    @Override
    public int compare(SolrFacetProperties facet1, SolrFacetProperties facet2) {
        if (this.sortedIDs.isEmpty()) {
            return facet1.getFilterID().compareTo(facet2.getFilterID());
        }
        Pair<Integer, Integer> facetIndicesInSortedList = this.find(facet1, facet2);
        if (this.bothSorted(facetIndicesInSortedList)) {
            return (Integer)facetIndicesInSortedList.getFirst() - (Integer)facetIndicesInSortedList.getSecond();
        }
        if (this.neitherSorted(facetIndicesInSortedList)) {
            return facet1.getFilterID().compareTo(facet2.getFilterID());
        }
        return (Integer)facetIndicesInSortedList.getSecond() == -1 ? -1 : 1;
    }

    private Pair<Integer, Integer> find(SolrFacetProperties facet1, SolrFacetProperties facet2) {
        return new Pair((Object)this.sortedIDs.indexOf(facet1.getFilterID()), (Object)this.sortedIDs.indexOf(facet2.getFilterID()));
    }

    private boolean bothSorted(Pair<Integer, Integer> indices) {
        return (Integer)indices.getFirst() != -1 && (Integer)indices.getSecond() != -1;
    }

    private boolean neitherSorted(Pair<Integer, Integer> indices) {
        return (Integer)indices.getFirst() == -1 && (Integer)indices.getSecond() == -1;
    }
}

