/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.nodelocator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.nodelocator.AbstractNodeLocator;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class AncestorNodeLocator
extends AbstractNodeLocator {
    public static final String NAME = "ancestor";
    public static final String TYPE_KEY = "type";
    public static final String ASPECT_KEY = "aspect";
    private NamespaceService namespaceService;
    private NodeService nodeService;

    @Override
    public NodeRef getNode(NodeRef source, Map<String, Serializable> params) {
        NodeRef parent;
        ChildAssociationRef parentAssoc;
        QName type = this.getQNameParam(TYPE_KEY, params);
        QName aspect = this.getQNameParam(ASPECT_KEY, params);
        NodeRef child = source;
        while ((parentAssoc = this.nodeService.getPrimaryParent(child)) != null && (parent = parentAssoc.getParentRef()) != null) {
            if (this.typeMatches(type, parent) && this.aspectMatches(aspect, parent)) {
                return parent;
            }
            child = parent;
        }
        return null;
    }

    @Override
    public List<ParameterDefinition> getParameterDefinitions() {
        ArrayList<ParameterDefinition> paramDefs = new ArrayList<ParameterDefinition>(2);
        paramDefs.add(new ParameterDefinitionImpl(TYPE_KEY, DataTypeDefinition.QNAME, false, "Type"));
        paramDefs.add(new ParameterDefinitionImpl(ASPECT_KEY, DataTypeDefinition.QNAME, false, "Aspect"));
        return paramDefs;
    }

    private boolean typeMatches(QName type, NodeRef parent) {
        return type == null || type.equals((Object)this.nodeService.getType(parent));
    }

    private boolean aspectMatches(QName aspect, NodeRef parent) {
        return aspect == null || this.nodeService.getAspects(parent).contains(aspect);
    }

    private QName getQNameParam(String key, Map<String, Serializable> params) {
        String value = (String)((Object)params.get(key));
        if (value != null) {
            return QName.createQName((String)value, (NamespacePrefixResolver)this.namespaceService);
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }
}

