/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.alfresco.repo.event2.DirectEventSender;
import org.alfresco.repo.event2.EnqueuingEventSender;
import org.alfresco.repo.event2.Event2MessageProducer;
import org.alfresco.repo.event2.EventSender;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.env.PropertyResolver;

public class EventSenderFactoryBean
extends AbstractFactoryBean<EventSender> {
    static final String LEGACY_SKIP_QUEUE_PROPERTY = "repo.event2.queue.skip";
    static final String EVENT_SEND_STRATEGY_PROPERTY = "repo.event2.send.strategy";
    private static final String DIRECT_EVENT_SENDER_NAME = "direct";
    private static final String ASYNC_EVENT_SENDER_NAME = "async";
    private final PropertyResolver propertyResolver;
    private final Event2MessageProducer event2MessageProducer;
    private final Executor enqueueThreadPoolExecutor;
    private final Executor dequeueThreadPoolExecutor;
    private String configuredSenderName;
    private boolean legacySkipQueueConfig;

    public EventSenderFactoryBean(@Autowired PropertyResolver propertyResolver, Event2MessageProducer event2MessageProducer, Executor enqueueThreadPoolExecutor, Executor dequeueThreadPoolExecutor) {
        PropertyCheck.mandatory((Object)((Object)this), (String)"propertyResolver", (Object)propertyResolver);
        PropertyCheck.mandatory((Object)((Object)this), (String)"event2MessageProducer", (Object)event2MessageProducer);
        PropertyCheck.mandatory((Object)((Object)this), (String)"enqueueThreadPoolExecutor", (Object)enqueueThreadPoolExecutor);
        PropertyCheck.mandatory((Object)((Object)this), (String)"dequeueThreadPoolExecutor", (Object)dequeueThreadPoolExecutor);
        this.propertyResolver = propertyResolver;
        this.event2MessageProducer = event2MessageProducer;
        this.enqueueThreadPoolExecutor = enqueueThreadPoolExecutor;
        this.dequeueThreadPoolExecutor = dequeueThreadPoolExecutor;
    }

    @Value(value="${repo.event2.queue.skip}")
    public void setLegacySkipQueueConfig(boolean legacySkipQueueConfig) {
        this.legacySkipQueueConfig = legacySkipQueueConfig;
    }

    @Value(value="${repo.event2.send.strategy}")
    public void setConfiguredSenderName(String configuredSenderName) {
        this.configuredSenderName = configuredSenderName;
    }

    public Class<?> getObjectType() {
        return EventSender.class;
    }

    @Nonnull
    protected EventSender createInstance() throws Exception {
        EventSender sender = this.instantiateConfiguredSender();
        sender.initialize();
        return sender;
    }

    private EventSender instantiateConfiguredSender() {
        if (this.isSenderNameConfigured()) {
            return this.instantiateSender(this.getConfiguredSenderName());
        }
        return this.isLegacySkipQueueConfigured() ? this.instantiateDirectSender() : this.instantiateAsyncSender();
    }

    protected EventSender instantiateSender(String senderName) {
        if (DIRECT_EVENT_SENDER_NAME.equalsIgnoreCase(senderName)) {
            return this.instantiateDirectSender();
        }
        if (ASYNC_EVENT_SENDER_NAME.equalsIgnoreCase(senderName)) {
            return this.instantiateAsyncSender();
        }
        throw new IllegalStateException("Failed to instantiate sender: " + senderName);
    }

    private DirectEventSender instantiateDirectSender() {
        return new DirectEventSender(this.getEvent2MessageProducer());
    }

    private EnqueuingEventSender instantiateAsyncSender() {
        return new EnqueuingEventSender(this.getEvent2MessageProducer(), this.enqueueThreadPoolExecutor, this.dequeueThreadPoolExecutor);
    }

    private boolean isSenderNameConfigured() {
        return Optional.ofNullable(this.getConfiguredSenderName()).map(String::isBlank).orElse(true) == false;
    }

    private boolean isLegacySkipQueueConfigured() {
        return Optional.ofNullable(this.resolveProperty(LEGACY_SKIP_QUEUE_PROPERTY, Boolean.class)).orElse(this.legacySkipQueueConfig);
    }

    private String getConfiguredSenderName() {
        return Optional.ofNullable(this.resolveProperty(EVENT_SEND_STRATEGY_PROPERTY, String.class)).orElse(this.configuredSenderName);
    }

    protected <T> T resolveProperty(String key, Class<T> targetType) {
        return (T)this.propertyResolver.getProperty(key, targetType);
    }

    protected Event2MessageProducer getEvent2MessageProducer() {
        return this.event2MessageProducer;
    }

    protected void destroyInstance(EventSender eventSender) {
        if (eventSender != null) {
            eventSender.destroy();
        }
    }
}

