/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.BPMEngine;
import org.alfresco.repo.workflow.WorkflowAuthorityManager;
import org.alfresco.repo.workflow.WorkflowObjectFactory;
import org.alfresco.repo.workflow.WorkflowQNameConverter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public abstract class AlfrescoBpmEngine
extends BPMEngine {
    protected TenantService tenantService;
    protected MessageService messageService;
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryService;
    protected WorkflowObjectFactory factory;
    protected WorkflowAuthorityManager authorityManager;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.tenantService == null) {
            throw new WorkflowException("TenantService not specified");
        }
        if (this.messageService == null) {
            throw new WorkflowException("MessageService not specified");
        }
        if (this.namespaceService == null) {
            throw new WorkflowException("NamespaceService not specified");
        }
        WorkflowQNameConverter qNameConverter = new WorkflowQNameConverter((NamespacePrefixResolver)this.namespaceService);
        QName defaultStartTaskType = this.getDefaultStartTaskType();
        this.factory = new WorkflowObjectFactory(qNameConverter, this.tenantService, this.messageService, this.dictionaryService, this.getEngineId(), defaultStartTaskType);
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setWorkflowObjectFactory(WorkflowObjectFactory factory) {
        this.factory = factory;
    }

    public void setWorkflowAuthorityManager(WorkflowAuthorityManager authorityManager) {
        this.authorityManager = authorityManager;
    }

    protected abstract QName getDefaultStartTaskType();
}

