/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.cleanup.AbstractNodeCleanupWorker;
import org.alfresco.repo.transaction.RetryingTransactionHelper;

public class DeletedNodeCleanupWorker
extends AbstractNodeCleanupWorker {
    private long minPurgeAgeMs = 604800000L;
    private long fromCustomCommitTime = -1L;
    private int purgeSize = 0x6DDD00;
    private String algorithm;
    private int deleteBatchSize;
    private static final String NODE_TABLE_CLEANER_ALG_V2 = "V2";

    @Override
    protected List<String> doCleanInternal() throws Throwable {
        List<String> purgedTxns;
        List<String> purgedNodes;
        if (this.minPurgeAgeMs < 0L) {
            return Collections.singletonList("Minimum purge age is negative; purge disabled");
        }
        if (NODE_TABLE_CLEANER_ALG_V2.equals(this.algorithm)) {
            this.refreshLock();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"DeletedNodeCleanupWorker using batch deletion: About to execute the clean up nodes ");
            }
            purgedNodes = this.purgeOldDeletedNodesV2(this.minPurgeAgeMs);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(purgedNodes);
            }
            this.refreshLock();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"DeletedNodeCleanupWorker: About to execute the clean up txns ");
            }
            purgedTxns = this.purgeOldEmptyTransactionsV2(this.minPurgeAgeMs);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"DeletedNodeCleanupWorker: About to start purgeOldDeletedNodes ");
            }
            purgedNodes = this.purgeOldDeletedNodes(this.minPurgeAgeMs);
            this.logger.debug(purgedNodes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"DeletedNodeCleanupWorker: About to start purgeOldEmptyTransactions ");
            }
            purgedTxns = this.purgeOldEmptyTransactions(this.minPurgeAgeMs);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(purgedTxns);
        }
        ArrayList<String> allResults = new ArrayList<String>(100);
        allResults.addAll(purgedNodes);
        allResults.addAll(purgedTxns);
        return allResults;
    }

    public void setMinPurgeAgeDays(int minPurgeAgeDays) {
        this.minPurgeAgeMs = (long)minPurgeAgeDays * 24L * 3600L * 1000L;
    }

    public void setFromCustomCommitTime(long fromCustomCommitTime) {
        this.fromCustomCommitTime = fromCustomCommitTime;
    }

    public void setPurgeSize(int purgeSize) {
        this.purgeSize = purgeSize;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setDeleteBatchSize(int deleteBatchSize) {
        this.deleteBatchSize = deleteBatchSize;
    }

    private List<String> purgeOldDeletedNodes(long minAge) {
        ArrayList<String> results = new ArrayList<String>(100);
        long maxCommitTime = System.currentTimeMillis() - minAge;
        long fromCommitTime = this.fromCustomCommitTime;
        if (fromCommitTime <= 0L) {
            fromCommitTime = this.nodeDAO.getMinTxnCommitTimeForDeletedNodes();
        }
        if (fromCommitTime == 0L) {
            String msg = "There are no old nodes to purge.";
            results.add(msg);
            return results;
        }
        long loopPurgeSize = this.purgeSize;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"DeletedNodeCleanupWorker: purgeOldDeletedNodes started ");
        }
        do {
            this.refreshLock();
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            txnHelper.setMaxRetries(5);
            txnHelper.setRetryWaitIncrementMs(1000);
            long toCommitTime = fromCommitTime + loopPurgeSize;
            if (toCommitTime > maxCommitTime) {
                toCommitTime = maxCommitTime;
            }
            try {
                DeleteNodesByTransactionsCallback purgeNodesCallback = new DeleteNodesByTransactionsCallback(this.nodeDAO, fromCommitTime, toCommitTime);
                Long purgeCount = txnHelper.doInTransaction(purgeNodesCallback, false, true);
                if (purgeCount > 0L) {
                    String msg = "Purged old nodes: \n   From commit time (ms):    " + fromCommitTime + "\n   To commit time (ms):      " + toCommitTime + "\n   Purge count:     " + String.valueOf(purgeCount);
                    results.add(msg);
                }
                fromCommitTime += loopPurgeSize;
                if ((loopPurgeSize *= 2L) <= (long)this.purgeSize) continue;
                loopPurgeSize = this.purgeSize;
            }
            catch (Throwable e) {
                String msg = "Failed to purge nodes. \n  If the purgable set is too large for the available DB resources \n  then the nodes can be purged manually as well. \n  Set log level to WARN for this class to get exception log: \n   From commit time (ms):    " + fromCommitTime + "\n   To commit time (ms):      " + toCommitTime + "\n   Error:       " + e.getMessage();
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)msg, e);
                } else {
                    this.logger.error((Object)msg);
                }
                results.add(msg);
                loopPurgeSize /= 2L;
                if (!((double)loopPurgeSize < 0.1 * (double)this.purgeSize)) continue;
                msg = "Failed to purge nodes. \n The purge time interval dropped below 10% of the original size (" + this.purgeSize + "), so the purging process was stopped.";
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)msg, e);
                } else {
                    this.logger.error((Object)msg);
                }
                results.add(msg);
                break;
            }
        } while (fromCommitTime < maxCommitTime);
        this.logger.debug((Object)"DeletedNodeCleanupWorker: purgeOldDeletedNodes finished ");
        return results;
    }

    private List<String> purgeOldEmptyTransactions(long minAge) {
        if (minAge < 0L) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(100);
        long maxCommitTime = System.currentTimeMillis() - minAge;
        long fromCommitTime = this.fromCustomCommitTime;
        if (fromCommitTime <= 0L) {
            fromCommitTime = this.nodeDAO.getMinUnusedTxnCommitTime();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"DeletedNodeCleanupWorker: purgeOldEmptyTransactions started ");
        }
        do {
            this.refreshLock();
            RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
            txnHelper.setMaxRetries(5);
            txnHelper.setRetryWaitIncrementMs(1000);
            long toCommitTime = fromCommitTime + (long)this.purgeSize;
            if (toCommitTime >= maxCommitTime) {
                toCommitTime = maxCommitTime;
            }
            try {
                DeleteTransactionsCallback purgeTxnsCallback = new DeleteTransactionsCallback(this.nodeDAO, fromCommitTime, toCommitTime);
                long purgeCount = txnHelper.doInTransaction(purgeTxnsCallback, false, true);
                if (purgeCount <= 0L) continue;
                String msg = "Purged old txns: \n   From commit time (ms):    " + fromCommitTime + "\n   To commit time (ms):      " + toCommitTime + "\n   Purge count:     " + purgeCount;
                results.add(msg);
            }
            catch (Throwable e) {
                String msg = "Failed to purge txns.  Set log level to WARN for this class to get exception log: \n   From commit time:      " + fromCommitTime + "\n   To commit time (ms):   " + toCommitTime + "\n   Error:       " + e.getMessage();
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)msg, e);
                } else {
                    this.logger.error((Object)msg);
                }
                results.add(msg);
                break;
            }
        } while ((fromCommitTime += (long)this.purgeSize) < maxCommitTime);
        this.logger.debug((Object)"DeletedNodeCleanupWorker: purgeOldEmptyTransactions finished ");
        return results;
    }

    private List<String> purgeOldDeletedNodesV2(long minAge) {
        this.refreshLock();
        ArrayList<String> returnList = new ArrayList<String>();
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = () -> {
            returnList.addAll(this.nodeDAO.purgeDeletedNodes(minAge, this.deleteBatchSize));
            return null;
        };
        txnHelper.doInTransaction(callback, false, true);
        return returnList;
    }

    private List<String> purgeOldEmptyTransactionsV2(long minAge) {
        this.refreshLock();
        ArrayList<String> returnList = new ArrayList<String>();
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = () -> {
            returnList.addAll(this.nodeDAO.purgeEmptyTransactions(minAge, this.deleteBatchSize));
            return null;
        };
        txnHelper.doInTransaction(callback, false, true);
        return returnList;
    }

    private static abstract class DeleteByTransactionsCallback
    implements RetryingTransactionHelper.RetryingTransactionCallback<Long> {
        protected NodeDAO nodeDAO;
        protected long fromCommitTime;
        protected long toCommitTime;

        DeleteByTransactionsCallback(NodeDAO nodeDAO, long fromCommitTime, long toCommitTime) {
            this.nodeDAO = nodeDAO;
            this.fromCommitTime = fromCommitTime;
            this.toCommitTime = toCommitTime;
        }

        @Override
        public abstract Long execute() throws Throwable;
    }

    private static class DeleteNodesByTransactionsCallback
    extends DeleteByTransactionsCallback {
        DeleteNodesByTransactionsCallback(NodeDAO nodeDAO, long fromCommitTime, long toCommitTime) {
            super(nodeDAO, fromCommitTime, toCommitTime);
        }

        @Override
        public Long execute() throws Throwable {
            long count = this.nodeDAO.purgeNodes(this.fromCommitTime, this.toCommitTime);
            return count;
        }
    }

    private static class DeleteTransactionsCallback
    extends DeleteByTransactionsCallback {
        DeleteTransactionsCallback(NodeDAO nodeDAO, long fromCommitTime, long toCommitTime) {
            super(nodeDAO, fromCommitTime, toCommitTime);
        }

        @Override
        public Long execute() throws Throwable {
            long count = this.nodeDAO.deleteTxnsUnused(this.fromCommitTime, this.toCommitTime);
            return count;
        }
    }
}

