/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.DaoAuthenticationProvider;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.CompositePasswordEncoder;
import org.alfresco.repo.security.authentication.RepositoryAuthenticatedUser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryAuthenticationProvider
extends DaoAuthenticationProvider {
    private static Log logger = LogFactory.getLog(RepositoryAuthenticationProvider.class);
    CompositePasswordEncoder compositePasswordEncoder;

    public void setCompositePasswordEncoder(CompositePasswordEncoder compositePasswordEncoder) {
        this.compositePasswordEncoder = compositePasswordEncoder;
    }

    protected boolean isPasswordCorrect(Authentication authentication, UserDetails user) {
        if (user instanceof RepositoryAuthenticatedUser) {
            RepositoryAuthenticatedUser repoUser = (RepositoryAuthenticatedUser)user;
            return this.compositePasswordEncoder.matchesPassword(authentication.getCredentials().toString(), user.getPassword(), repoUser.getSalt(), repoUser.getHashIndicator());
        }
        logger.error((Object)("Password check error for '" + AuthenticationUtil.maskUsername((String)user.getUsername()) + "'; unknown user type: " + user.getClass().getName()));
        return false;
    }
}

