/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.HashStore;
import org.alfresco.repo.virtual.ref.HashStoreConfiguration;
import org.alfresco.repo.virtual.ref.StoreRefHasher;
import org.alfresco.service.cmr.repository.StoreRef;

class StoredStoreRefHasher
implements StoreRefHasher {
    private final HashStore storeProtocolStore = HashStoreConfiguration.getInstance().getStoreProtocolStore();
    private final HashStore storeIdStore = HashStoreConfiguration.getInstance().getStoreIdStore();

    @Override
    public StoreRef lookup(String storeHash) {
        String storeProtocolHash = storeHash.substring(0, 1);
        String storeIdHash = storeHash.substring(1, 2);
        String storeProtocol = this.storeProtocolStore.lookup(storeProtocolHash);
        String storeId = this.storeIdStore.lookup(storeIdHash);
        if (storeProtocol == null || storeId == null) {
            throw new RuntimeException("Lookup found no protocol or id for " + storeHash);
        }
        return new StoreRef(storeProtocol, storeId);
    }

    @Override
    public String hash(StoreRef storeRef) {
        String storeProtocolHash = this.storeProtocolStore.hash(storeRef.getProtocol());
        String storeIdHash = this.storeIdStore.hash(storeRef.getIdentifier());
        if (storeProtocolHash == null || storeIdHash == null) {
            throw new RuntimeException("Missing hash for " + String.valueOf(storeRef));
        }
        return storeProtocolHash + storeIdHash;
    }
}

