/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FieldGroup;
import org.alfresco.repo.forms.processor.node.AssociationFieldProcessor;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.NamespaceService;

public class FieldUtils {
    public static Field makePropertyField(PropertyDefinition propDef, Object value, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        PropertyFieldProcessor processor = new PropertyFieldProcessor(namespaceService, dictionaryService);
        return processor.makeField(propDef, value, group);
    }

    public static List<Field> makePropertyFields(Collection<PropertyDefinition> propDefs, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        return FieldUtils.makePropertyFields(propDefs, null, group, namespaceService, dictionaryService);
    }

    public static List<Field> makePropertyFields(Map<PropertyDefinition, Object> propDefAndValue, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        return FieldUtils.makePropertyFields(propDefAndValue.keySet(), propDefAndValue, group, namespaceService, dictionaryService);
    }

    public static List<Field> makePropertyFields(Collection<PropertyDefinition> propDefs, Map<PropertyDefinition, Object> values, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        PropertyFieldProcessor processor = new PropertyFieldProcessor(namespaceService, dictionaryService);
        ArrayList<Field> fields = new ArrayList<Field>(propDefs.size());
        for (PropertyDefinition propDef : propDefs) {
            Object value = values == null ? null : values.get(propDef);
            Field field = processor.makeField(propDef, value, group);
            fields.add(field);
        }
        return fields;
    }

    public static Field makeAssociationField(AssociationDefinition assocDef, Object value, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        AssociationFieldProcessor processor = new AssociationFieldProcessor(namespaceService, dictionaryService);
        return processor.makeField(assocDef, value, group);
    }

    public static List<Field> makeAssociationFields(Collection<AssociationDefinition> assocDefs, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        return FieldUtils.makeAssociationFields(assocDefs, null, group, namespaceService, dictionaryService);
    }

    public static List<Field> makeAssociationFields(Map<AssociationDefinition, Object> assocDefAndValue, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        return FieldUtils.makeAssociationFields(assocDefAndValue.keySet(), assocDefAndValue, group, namespaceService, dictionaryService);
    }

    public static List<Field> makeAssociationFields(Collection<AssociationDefinition> assocDefs, Map<AssociationDefinition, Object> values, FieldGroup group, NamespaceService namespaceService, DictionaryService dictionaryService) {
        AssociationFieldProcessor processor = new AssociationFieldProcessor(namespaceService, dictionaryService);
        ArrayList<Field> fields = new ArrayList<Field>(assocDefs.size());
        for (AssociationDefinition propDef : assocDefs) {
            Object value = values == null ? null : values.get(propDef);
            Field field = processor.makeField(propDef, value, group);
            fields.add(field);
        }
        return fields;
    }
}

