/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.schema.script;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.schema.script.DeleteNotExistsExecutor;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteNotExistsV3Executor
extends DeleteNotExistsExecutor {
    private static Log logger = LogFactory.getLog(DeleteNotExistsV3Executor.class);
    public static final String PROPERTY_PAUSE_AND_RECOVER_BATCHSIZE = "system.delete_not_exists.pauseAndRecoverBatchSize";
    public static final String PROPERTY_PAUSE_AND_RECOVER_TIME = "system.delete_not_exists.pauseAndRecoverTime";
    public static final long DEFAULT_PAUSE_AND_RECOVER_BATCHSIZE = 500000L;
    public static final long DEFAULT_PAUSE_AND_RECOVER_TIME = 300000L;
    private Dialect dialect;
    private final DataSource dataSource;
    private long pauseAndRecoverTime;
    private long pauseAndRecoverBatchSize;
    private boolean pauseAndRecover = false;
    private int processedCounter = 0;

    public DeleteNotExistsV3Executor(Dialect dialect, Connection connection, String sql, int line, File scriptFile, Properties globalProperties, DataSource dataSource) {
        super(connection, sql, line, scriptFile, globalProperties);
        this.dialect = dialect;
        this.dataSource = dataSource;
    }

    @Override
    public void execute() throws Exception {
        this.checkProperties();
        String pauseAndRecoverBatchSizeString = this.globalProperties.getProperty(PROPERTY_PAUSE_AND_RECOVER_BATCHSIZE);
        this.pauseAndRecoverBatchSize = pauseAndRecoverBatchSizeString == null ? 500000L : Long.parseLong(pauseAndRecoverBatchSizeString);
        String pauseAndRecoverTimeString = this.globalProperties.getProperty(PROPERTY_PAUSE_AND_RECOVER_TIME);
        this.pauseAndRecoverTime = pauseAndRecoverTimeString == null ? 300000L : Long.parseLong(pauseAndRecoverTimeString);
        super.execute();
    }

    @Override
    protected void process(Pair<String, String>[] tableColumn, Long[] tableUpperLimits, String[] optionalWhereClauses) throws SQLException {
        this.process(tableColumn, tableUpperLimits, optionalWhereClauses, 0L);
    }

    @Override
    protected void process(Pair<String, String>[] tableColumn, Long[] tableUpperLimits, String[] optionalWhereClauses, Long skipToId) throws SQLException {
        String primaryTableName = (String)tableColumn[0].getFirst();
        String primaryColumnName = (String)tableColumn[0].getSecond();
        String primaryWhereClause = optionalWhereClauses[0];
        Long primaryId = skipToId;
        this.deletedCount = 0L;
        this.startTime = new Date();
        this.processBatch(primaryTableName, primaryColumnName, primaryWhereClause, primaryId, tableColumn, tableUpperLimits, optionalWhereClauses);
        if (logger.isDebugEnabled()) {
            String msg = (this.readOnly ? "Script would have" : "Script") + " deleted a total of " + this.deletedCount + " items from table " + primaryTableName + ".";
            logger.debug((Object)msg);
        }
    }

    private void processBatch(String primaryTableName, String primaryColumnName, String primaryWhereClause, Long primaryId, Pair<String, String>[] tableColumn, Long[] tableUpperLimits, String[] optionalWhereClauses) throws SQLException {
        PreparedStatement primaryPrepStmt = null;
        Statement[] secondaryPrepStmts = null;
        PreparedStatement deletePrepStmt = null;
        HashSet<Long> deleteIds = new HashSet<Long>();
        this.pauseAndRecover = false;
        try {
            this.connection.setAutoCommit(false);
            primaryPrepStmt = this.connection.prepareStatement(this.createPreparedSelectStatement(primaryTableName, primaryColumnName, primaryWhereClause));
            primaryPrepStmt.setFetchSize(this.batchSize);
            primaryPrepStmt.setLong(1, primaryId);
            primaryPrepStmt.setLong(2, tableUpperLimits[0]);
            boolean hasResults = primaryPrepStmt.execute();
            if (hasResults) {
                secondaryPrepStmts = new PreparedStatement[tableColumn.length];
                int i = 1;
                while (i < tableColumn.length) {
                    PreparedStatement secStmt = this.connection.prepareStatement(this.createPreparedSelectStatement((String)tableColumn[i].getFirst(), (String)tableColumn[i].getSecond(), optionalWhereClauses[i]));
                    secStmt.setFetchSize(this.batchSize);
                    secondaryPrepStmts[i] = secStmt;
                    ++i;
                }
                deletePrepStmt = this.connection.prepareStatement(this.createPreparedDeleteStatement(primaryTableName, primaryColumnName, this.deleteBatchSize, primaryWhereClause));
                while (hasResults && !this.isTimeoutExceeded()) {
                    primaryId = this.processPrimaryTableResultSet(primaryPrepStmt, (PreparedStatement[])secondaryPrepStmts, deletePrepStmt, deleteIds, primaryTableName, primaryColumnName, tableColumn);
                    this.connection.commit();
                    if (primaryId == null || this.pauseAndRecover) break;
                    primaryPrepStmt.setLong(1, primaryId + 1L);
                    primaryPrepStmt.setLong(2, tableUpperLimits[0]);
                    hasResults = primaryPrepStmt.execute();
                }
                if (!deleteIds.isEmpty()) {
                    this.deleteFromPrimaryTable(deletePrepStmt, deleteIds, primaryTableName);
                    this.connection.commit();
                }
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(deletePrepStmt);
            this.closeQuietly(secondaryPrepStmts);
            this.closeQuietly(primaryPrepStmt);
            this.closeQuietly(this.connection);
            throw throwable;
        }
        this.closeQuietly(deletePrepStmt);
        this.closeQuietly(secondaryPrepStmts);
        this.closeQuietly(primaryPrepStmt);
        this.closeQuietly(this.connection);
        if (this.pauseAndRecover) {
            this.pauseAndRecoverJob(this.dataSource);
            logger.info((Object)("Resuming the job on primary table " + primaryTableName + " picking up after id " + String.valueOf(primaryId)));
            this.processBatch(primaryTableName, primaryColumnName, primaryWhereClause, primaryId, tableColumn, tableUpperLimits, optionalWhereClauses);
        }
    }

    @Override
    protected String createPreparedSelectStatement(String tableName, String columnName, String whereClause) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT " + columnName + " FROM " + tableName + " WHERE ");
        if (whereClause != null && !whereClause.isEmpty()) {
            sqlBuilder.append(whereClause + " AND ");
        }
        sqlBuilder.append(columnName + " >= ? AND " + columnName + " <= ? GROUP BY " + columnName + " ORDER BY " + columnName + " ASC ");
        if (this.dialect instanceof MySQLInnoDBDialect) {
            sqlBuilder.append(" LIMIT " + this.batchSize);
        } else {
            sqlBuilder.append(" OFFSET 0 ROWS FETCH FIRST " + this.batchSize + " ROWS ONLY");
        }
        return sqlBuilder.toString();
    }

    @Override
    protected Long processPrimaryTableResultSet(PreparedStatement primaryPrepStmt, PreparedStatement[] secondaryPrepStmts, PreparedStatement deletePrepStmt, Set<Long> deleteIds, String primaryTableName, String primaryColumnName, Pair<String, String>[] tableColumn) throws SQLException {
        Long primaryId = null;
        Long minSecId = 0L;
        Long maxSecId = 0L;
        HashSet<Long> potentialIdsToDelete = new HashSet<Long>();
        Long minPotentialId = 0L;
        Long maxPotentialId = 0L;
        Throwable throwable = null;
        Object var15_17 = null;
        try (ResultSet resultSet = primaryPrepStmt.getResultSet();){
            while (resultSet.next()) {
                primaryId = resultSet.getLong(primaryColumnName);
                potentialIdsToDelete.add(primaryId);
                minPotentialId = minPotentialId == 0L || primaryId < minPotentialId ? primaryId : minPotentialId;
                Long l = maxPotentialId = primaryId > maxPotentialId ? primaryId : maxPotentialId;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (potentialIdsToDelete.size() == 0) {
            return primaryId;
        }
        int rowsInBatch = potentialIdsToDelete.size();
        this.processedCounter += rowsInBatch;
        SecondaryResultsInfo secondaryResultsInfo = this.getSecondaryResults(secondaryPrepStmts, tableColumn, minPotentialId, maxPotentialId);
        Set<Long> secondaryResults = secondaryResultsInfo.getValues();
        if (secondaryResultsInfo.getSize() > 0L) {
            minSecId = secondaryResultsInfo.getMinValue();
            maxSecId = secondaryResultsInfo.getMaxValue();
            Iterator it = potentialIdsToDelete.iterator();
            while (it.hasNext()) {
                Long id = (Long)it.next();
                if (id <= maxSecId && !secondaryResults.contains(id)) continue;
                it.remove();
            }
            Long l = primaryId = primaryId < maxSecId ? primaryId : maxSecId;
        }
        if (potentialIdsToDelete.size() > 0) {
            this.deleteInBatches(potentialIdsToDelete, deleteIds, primaryTableName, deletePrepStmt);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Rows processed " + rowsInBatch + " from primary table " + primaryTableName + ". Primary: [" + String.valueOf(minPotentialId) + "," + String.valueOf(maxPotentialId) + "] Secondary rows processed: " + secondaryResultsInfo.getSize() + " [" + String.valueOf(minSecId) + "," + String.valueOf(maxSecId) + "] Total Deleted: " + this.deletedCount));
        }
        if ((long)this.processedCounter >= this.pauseAndRecoverBatchSize) {
            this.pauseAndRecover = true;
        }
        return primaryId;
    }

    private void deleteInBatches(Set<Long> potentialIdsToDelete, Set<Long> deleteIds, String primaryTableName, PreparedStatement deletePrepStmt) throws SQLException {
        for (Long idToDelete : potentialIdsToDelete) {
            deleteIds.add(idToDelete);
            if (deleteIds.size() != this.deleteBatchSize) continue;
            this.deleteFromPrimaryTable(deletePrepStmt, deleteIds, primaryTableName);
        }
    }

    private SecondaryResultsInfo getSecondaryResults(PreparedStatement[] preparedStatements, Pair<String, String>[] tableColumn, Long minPotentialId, Long maxPotentialId) throws SQLException {
        HashSet<Long> secondaryResultValues = new HashSet<Long>();
        Long lowestUpperValue = 0L;
        int i = 1;
        while (i < preparedStatements.length) {
            String columnId = (String)tableColumn[i].getSecond();
            PreparedStatement secStmt = preparedStatements[i];
            secStmt.setLong(1, minPotentialId);
            secStmt.setLong(2, maxPotentialId);
            boolean secHasResults = secStmt.execute();
            if (secHasResults) {
                Throwable throwable = null;
                Object var12_15 = null;
                try (ResultSet secResultSet = secStmt.getResultSet();){
                    Long thisId = 0L;
                    Long resultSize = 0L;
                    Long upperValue = 0L;
                    while (secResultSet.next()) {
                        resultSize = resultSize + 1L;
                        thisId = secResultSet.getLong(columnId);
                        if (!secondaryResultValues.contains(thisId)) {
                            secondaryResultValues.add(thisId);
                        }
                        Long l = upperValue = thisId > upperValue ? thisId : upperValue;
                    }
                    if (upperValue > 0L && resultSize == (long)this.batchSize) {
                        lowestUpperValue = lowestUpperValue == 0L || upperValue < lowestUpperValue ? upperValue : lowestUpperValue;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++i;
        }
        lowestUpperValue = lowestUpperValue == 0L ? maxPotentialId : lowestUpperValue;
        long minSecId = 0L;
        Iterator it = secondaryResultValues.iterator();
        while (it.hasNext()) {
            long secondaryId = (Long)it.next();
            if (secondaryId > lowestUpperValue) {
                it.remove();
                continue;
            }
            long l = minSecId = minSecId == 0L || secondaryId < minSecId ? secondaryId : minSecId;
        }
        return new SecondaryResultsInfo(secondaryResultValues, minSecId, lowestUpperValue);
    }

    private void pauseAndRecoverJob(DataSource dataSource) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reached batch size for pause and recovery. Job will resume in " + this.pauseAndRecoverTime + " ms"));
        }
        try {
            Thread.sleep(this.pauseAndRecoverTime);
        }
        catch (InterruptedException interruptedException) {}
        this.connection = dataSource.getConnection();
        this.pauseAndRecover = false;
        this.processedCounter = 0;
    }

    protected void closeQuietly(Connection connection) {
        try {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                connection = null;
            }
        }
        finally {
            connection = null;
        }
    }

    private class SecondaryResultsInfo {
        Set<Long> values;
        long minValue;
        long maxValue;
        long size;

        public SecondaryResultsInfo(Set<Long> values, long minValue, long maxValue) {
            this.values = values;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.size = values.size();
        }

        public Set<Long> getValues() {
            return this.values;
        }

        public long getMinValue() {
            return this.minValue;
        }

        public long getMaxValue() {
            return this.maxValue;
        }

        public long getSize() {
            return this.size;
        }
    }
}

