/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.util.List;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.DotDotContentSearchContext;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheLookupSearchContext
extends DotDotContentSearchContext {
    private static final Log logger = LogFactory.getLog(CacheLookupSearchContext.class);
    private FileStateCache m_stateCache;

    protected CacheLookupSearchContext(CifsHelper cifsHelper, List<NodeRef> results, String searchStr, String relPath, FileStateCache stateCache, boolean lockedFilesAsOffline) {
        super(cifsHelper, results, searchStr, relPath, lockedFilesAsOffline);
        super.setSearchString(searchStr);
        this.m_stateCache = stateCache;
    }

    @Override
    public boolean nextFileInfo(FileInfo info) {
        if (!super.nextFileInfo(info)) {
            return false;
        }
        StringBuilder relPath = new StringBuilder(this.getRelativePath());
        relPath.append(info.getFileName());
        FileState fstate = this.m_stateCache.findFileState(relPath.toString());
        if (fstate != null) {
            if (fstate.hasAccessDateTime()) {
                info.setAccessDateTime(fstate.getAccessDateTime());
            }
            if (fstate.hasModifyDateTime()) {
                info.setModifyDateTime(fstate.getModifyDateTime());
            }
            if (fstate.hasFileSize()) {
                info.setFileSize(fstate.getFileSize());
            }
            if (fstate.hasAllocationSize() && fstate.getAllocationSize() > info.getSize()) {
                info.setAllocationSize(fstate.getAllocationSize());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Search timestamps from cache, path=" + info.getFileName()));
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("[CacheLookupSearchContext searchStr=");
        sb.append(this.getSearchString());
        sb.append(", resultCount=");
        sb.append(this.getResultsSize());
        sb.append(",cache=");
        sb.append(this.m_stateCache);
        sb.append("]");
        return sb.toString();
    }
}

