/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.cache.DefaultSimpleCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.AbstractRoutingContentStore;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.TempFileProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={OwnJVMTestsCategory.class})
public class RoutingContentStoreTest
extends AbstractWritableContentStoreTest {
    private ContentStore storeA;
    private ContentStore storeB;
    private ContentStore storeC;
    private ContentStore storeD;
    private ContentStore routingStore;

    @Override
    @Before
    public void before() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        File storeADir = new File(tempDir, "A");
        this.storeA = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, storeADir);
        File storeBDir = new File(tempDir, "B");
        this.storeB = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, storeBDir);
        File storeCDir = new File(tempDir, "C");
        this.storeC = new DumbReadOnlyFileStore(new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, storeCDir));
        this.storeD = new SupportsNoUrlFormatStore();
        this.routingStore = new RandomRoutingContentStore(this.storeA, this.storeB, this.storeC, this.storeD);
    }

    @Override
    protected ContentStore getStore() {
        return this.routingStore;
    }

    @Override
    @Test
    public void testSetUp() throws Exception {
        Assert.assertNotNull((Object)this.routingStore);
    }

    private void checkForContent(String contentUrl, String content) {
        ContentStore[] contentStoreArray = new ContentStore[]{this.storeA, this.storeB};
        int n = contentStoreArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentStore store = contentStoreArray[n2];
            if (store.exists(contentUrl)) {
                ContentReader reader = store.getReader(contentUrl);
                String checkContent = reader.getContentString();
                Assert.assertEquals((String)"Content found but is incorrect", (Object)content, (Object)checkContent);
                return;
            }
            ++n2;
        }
        Assert.fail((String)("Content not found in any of the stores: " + contentUrl));
    }

    @Test
    public void testMissingUrl() {
        String missingContentUrl = FileContentStore.createNewFileStoreUrl();
        ContentReader reader = this.routingStore.getReader(missingContentUrl);
        Assert.assertNotNull((String)"Missing URL should not return null", (Object)reader);
        Assert.assertFalse((String)"Empty reader should say content doesn't exist.", (boolean)reader.exists());
        try {
            reader.getContentString();
            Assert.fail((String)"Empty reader cannot return content.");
        }
        catch (Throwable throwable) {}
    }

    @Test
    public void testGeneralUse() {
        int i = 0;
        while (i < 20) {
            ContentContext contentContext = new ContentContext(null, null);
            ContentWriter writer = this.routingStore.getWriter(contentContext);
            String content = "This was generated by " + this.getClass().getName() + "#testGeneralUse number " + i;
            writer.putContent(content);
            String contentUrl = writer.getContentUrl();
            this.checkForContent(contentUrl, content);
            ContentReader reader = this.routingStore.getReader(contentUrl);
            Assert.assertNotNull((String)"Null reader returned", (Object)reader);
            Assert.assertTrue((String)"Reader should be onto live content", (boolean)reader.exists());
            ++i;
        }
    }

    private static class DumbReadOnlyFileStore
    extends AbstractContentStore {
        FileContentStore fileStore;

        public DumbReadOnlyFileStore(FileContentStore fileStore) {
            this.fileStore = fileStore;
        }

        public boolean isWriteSupported() {
            return false;
        }

        public ContentReader getReader(String contentUrl) {
            return this.fileStore.getReader(contentUrl);
        }
    }

    private static class RandomRoutingContentStore
    extends AbstractRoutingContentStore {
        private List<ContentStore> stores = new ArrayList<ContentStore>(5);

        public RandomRoutingContentStore(ContentStore ... stores) {
            ContentStore[] contentStoreArray = stores;
            int n = stores.length;
            int n2 = 0;
            while (n2 < n) {
                ContentStore store = contentStoreArray[n2];
                this.stores.add(store);
                ++n2;
            }
            DefaultSimpleCache cache = new DefaultSimpleCache(11, ((Object)((Object)this)).getClass().getName());
            super.setStoresCache((SimpleCache)cache);
        }

        protected List<ContentStore> getAllStores() {
            return this.stores;
        }

        protected ContentStore selectWriteStore(ContentContext ctx) {
            ArrayList<ContentStore> shuffled = new ArrayList<ContentStore>(this.stores);
            Collections.shuffle(shuffled);
            for (ContentStore store : shuffled) {
                if (!store.isWriteSupported()) continue;
                return store;
            }
            Assert.fail((String)"A request came for a writer when there is no writable store to choose from");
            return null;
        }
    }

    private static class SupportsNoUrlFormatStore
    extends AbstractContentStore {
        public boolean isWriteSupported() {
            return false;
        }

        public ContentReader getReader(String contentUrl) {
            throw new UnsupportedContentUrlException((ContentStore)this, contentUrl);
        }
    }
}

