/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class UserAuditFilter
implements InitializingBean {
    private static final char NOT = '~';
    private static final String REG_EXP_SEPARATOR = ";";
    private static final char ESCAPE = '\\';
    private static final String ESCAPED_NOT = "\\~";
    private String userFilterPattern;
    private List<Pair<Boolean, Pattern>> listOfPairValue = new ArrayList<Pair<Boolean, Pattern>>();

    public void setUserFilterPattern(String userFilterPattern) {
        this.userFilterPattern = userFilterPattern;
    }

    public void afterPropertiesSet() {
        this.parseProperties();
    }

    private void parseProperties() {
        String[] arrValues;
        String userPropertyValue = this.userFilterPattern;
        if (!PropertyCheck.isValidPropertyString((String)userPropertyValue)) {
            return;
        }
        String[] stringArray = arrValues = userPropertyValue.split(REG_EXP_SEPARATOR);
        int n = arrValues.length;
        int n2 = 0;
        while (n2 < n) {
            boolean includeExp;
            String prop = stringArray[n2];
            boolean bl = includeExp = prop.charAt(0) != '~';
            if (!includeExp || prop.startsWith(ESCAPED_NOT)) {
                prop = prop.substring(1);
            }
            try {
                this.listOfPairValue.add((Pair<Boolean, Pattern>)new Pair((Object)includeExp, (Object)Pattern.compile(prop)));
            }
            catch (PatternSyntaxException ex) {
                throw new AlfrescoRuntimeException("The 'audit.filter.alfresco-access.transaction.user' property parse exception; see property 'audit.filter.alfresco-access.transaction.user'.", (Throwable)ex);
            }
            ++n2;
        }
    }

    public boolean acceptUser(String value) {
        if (value == null) {
            value = "null";
        }
        for (Pair<Boolean, Pattern> val : this.listOfPairValue) {
            if (!((Pattern)val.getSecond()).matcher(value).matches()) continue;
            return (Boolean)val.getFirst();
        }
        return true;
    }
}

