/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.tenant.TenantAdminDAO;
import org.alfresco.repo.domain.tenant.TenantEntity;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateTenantsFromAttrsToTablePatch
extends AbstractPatch {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String MSG_SUCCESS = "patch.migrateTenantsFromAttrsToTable.result";
    private AttributeService attributeService;
    private TenantAdminDAO tenantAdminDAO;

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setTenantAdminDAO(TenantAdminDAO tenantAdminDAO) {
        this.tenantAdminDAO = tenantAdminDAO;
    }

    @Override
    protected String applyInternal() throws Exception {
        long startTime = System.currentTimeMillis();
        final ArrayList tenantsToMigrate = new ArrayList(10);
        this.attributeService.getAttributes(new AttributeService.AttributeQueryCallback(){

            @Override
            public boolean handleAttribute(Long id, Serializable value, Serializable[] keys) {
                if (keys.length >= 2 && value != null) {
                    String tenantDomain = (String)((Object)keys[1]);
                    Map valueMap = (Map)((Object)value);
                    Boolean isEnabled = (Boolean)valueMap.get("enabled");
                    String rootDir = (String)valueMap.get("rootContentStoreDir");
                    TenantEntity tenantEntity = new TenantEntity(new String(tenantDomain));
                    tenantEntity.setEnabled(isEnabled != null ? isEnabled : false);
                    tenantEntity.setContentRoot(new String(rootDir));
                    TenantEntity tenantEntityCreated = MigrateTenantsFromAttrsToTablePatch.this.tenantAdminDAO.createTenant(tenantEntity);
                    tenantsToMigrate.add(tenantEntityCreated);
                    if (MigrateTenantsFromAttrsToTablePatch.this.logger.isInfoEnabled()) {
                        MigrateTenantsFromAttrsToTablePatch.this.logger.info((Object)("... migrated: " + String.valueOf(tenantEntityCreated)));
                    }
                }
                return true;
            }
        }, new Serializable[]{"alfresco-tenants"});
        int tenantCount = tenantsToMigrate.size();
        if (tenantCount > 0) {
            for (TenantEntity tenantEntity : tenantsToMigrate) {
                this.attributeService.removeAttribute(new Serializable[]{"alfresco-tenants", tenantEntity.getTenantDomain()});
            }
            final ArrayList checkTenants = new ArrayList(10);
            this.attributeService.getAttributes(new AttributeService.AttributeQueryCallback(){

                @Override
                public boolean handleAttribute(Long id, Serializable value, Serializable[] keys) {
                    if (keys.length >= 2 && value != null) {
                        String tenantDomain = (String)((Object)keys[1]);
                        MigrateTenantsFromAttrsToTablePatch.this.logger.error((Object)("Unexpected tenant attribute: " + tenantDomain + " [not migrated/removed]"));
                        checkTenants.add(tenantDomain);
                    }
                    return true;
                }
            }, new Serializable[]{"alfresco-tenants"});
            if (checkTenants.size() > 0) {
                throw new AlfrescoRuntimeException("Incomplete migration of tenant attributes to tenant table: " + checkTenants.size());
            }
            this.tenantAdminService.startTenants();
            this.logger.info((Object)("Processed " + tenantCount + " Tenant attrs in " + (System.currentTimeMillis() - startTime) / 1000L + " secs"));
        }
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{tenantCount});
        return msg;
    }
}

