/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.transform.LocalTransformServiceRegistry;
import org.alfresco.repo.rendition2.AbstractRenditionIntegrationTest;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalTransformServiceRegistryIntegrationTest
extends AbstractRenditionIntegrationTest {
    private static final String RENDITION_NAME = "pdf";
    protected String targetMimetype = "rubbish";
    @Autowired
    private LocalTransformServiceRegistry localTransformServiceRegistry;
    protected TransformServiceRegistry transformServiceRegistry;
    private Map<String, String> options;

    @BeforeClass
    public static void before() {
        AbstractRenditionIntegrationTest.before();
        LocalTransformServiceRegistryIntegrationTest.local();
    }

    @AfterClass
    public static void after() {
        AbstractRenditionIntegrationTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.transformServiceRegistry = this.localTransformServiceRegistry;
        RenditionDefinition2 definition2 = this.renditionDefinitionRegistry2.getRenditionDefinition(RENDITION_NAME);
        this.options = definition2.getTransformOptions();
    }

    protected void setEnabled(boolean enabled) throws Exception {
        this.localTransformServiceRegistry.setEnabled(enabled);
        this.localTransformServiceRegistry.afterPropertiesSet();
    }

    protected boolean isEnabled() {
        return this.localTransformServiceRegistry.isEnabled();
    }

    @Test
    public void testIsSupported() {
        List transformers = this.localTransformServiceRegistry.findTransformers("application/vnd.apple.pages", this.targetMimetype, this.options, RENDITION_NAME);
        LocalTransformServiceRegistryIntegrationTest.assertEquals((int)1, (int)transformers.size());
        Assert.assertTrue((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 1234L, this.targetMimetype, this.options, RENDITION_NAME));
        Assert.assertFalse((boolean)this.transformServiceRegistry.isSupported("docxBad", 1234L, this.targetMimetype, this.options, RENDITION_NAME));
        Assert.assertFalse((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 1234L, "pdfBad", this.options, "pdfBad"));
        Assert.assertTrue((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 786432L, this.targetMimetype, this.options, RENDITION_NAME));
        Assert.assertFalse((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 786433L, this.targetMimetype, this.options, RENDITION_NAME));
    }

    @Test
    public void testNoOptions() {
        Assert.assertTrue((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 1234L, "image/jpeg", this.options, "custom"));
    }

    @Test
    public void testBadOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("timeout", "true");
        options.put("unknown", "optionValue");
        Assert.assertFalse((boolean)this.transformServiceRegistry.isSupported("docxBad", 1234L, "image/jpeg", options, ""));
    }

    @Test
    public void testEnabledDisabled() throws Exception {
        boolean origEnabled = this.isEnabled();
        try {
            Assert.assertTrue((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 1234L, this.targetMimetype, this.options, RENDITION_NAME));
            this.setEnabled(false);
            Assert.assertFalse((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 1234L, this.targetMimetype, this.options, RENDITION_NAME));
            this.setEnabled(true);
            Assert.assertTrue((boolean)this.transformServiceRegistry.isSupported("application/vnd.apple.pages", 1234L, this.targetMimetype, this.options, RENDITION_NAME));
        }
        finally {
            this.setEnabled(origEnabled);
        }
    }
}

