/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.script;

import java.util.List;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.rendition.script.ScriptRenditionDefinition;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.rendition.RenderingEngineDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class ScriptRenditionService
extends BaseScopableProcessorExtension {
    private static Log logger = LogFactory.getLog(ScriptRenditionService.class);
    private ServiceRegistry serviceRegistry;
    private RenditionService renditionService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.renditionService = serviceRegistry.getRenditionService();
    }

    private RenditionDefinition loadRenditionDefinitionImpl(String shortOrLongFormQName) {
        final QName renditionName = this.createQName(shortOrLongFormQName);
        RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

            public RenditionDefinition doWork() throws Exception {
                return ScriptRenditionService.this.renditionService.loadRenditionDefinition(renditionName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return rendDefn;
    }

    public ScriptRenditionDefinition createRenditionDefinition(String renditionName, String renderingEngineName) {
        QName renditionQName = this.createQName(renditionName);
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating ScriptRenditionDefinition [").append(renditionName).append(", ").append(renderingEngineName).append("]");
            logger.debug((Object)msg.toString());
        }
        RenderingEngineDefinition engineDefinition = this.renditionService.getRenderingEngineDefinition(renderingEngineName);
        RenditionDefinition rendDef = this.renditionService.createRenditionDefinition(renditionQName, renderingEngineName);
        return new ScriptRenditionDefinition(this.serviceRegistry, this.getScope(), engineDefinition, rendDef);
    }

    public ScriptNode render(ScriptNode sourceNode, String renditionDefQName) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rendering source node '").append(sourceNode).append("' with renditionDef '").append(renditionDefQName).append("'");
            logger.debug((Object)msg.toString());
        }
        RenditionDefinition rendDef = this.loadRenditionDefinitionImpl(renditionDefQName);
        ChildAssociationRef result = this.renditionService.render(sourceNode.getNodeRef(), rendDef);
        NodeRef renditionNode = result.getChildRef();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rendition: ").append(renditionNode);
            logger.debug((Object)msg.toString());
        }
        return new ScriptNode(renditionNode, this.serviceRegistry);
    }

    public ScriptNode render(ScriptNode sourceNode, ScriptRenditionDefinition scriptRenditionDef) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rendering source node '").append(sourceNode).append("' with renditionDefQName '").append(scriptRenditionDef).append("'");
            logger.debug((Object)msg.toString());
        }
        ChildAssociationRef chAssRef = this.renditionService.render(sourceNode.getNodeRef(), scriptRenditionDef.getRenditionDefinition());
        NodeRef renditionNode = chAssRef.getChildRef();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rendition: ").append(renditionNode);
            logger.debug((Object)msg.toString());
        }
        return new ScriptNode(renditionNode, this.serviceRegistry);
    }

    public ScriptNode[] getRenditions(ScriptNode node) {
        List<ChildAssociationRef> renditions = this.renditionService.getRenditions(node.getNodeRef());
        ScriptNode[] renditionObjs = new ScriptNode[renditions.size()];
        int i = 0;
        while (i < renditions.size()) {
            renditionObjs[i] = new ScriptNode(renditions.get(i).getChildRef(), this.serviceRegistry);
            ++i;
        }
        return renditionObjs;
    }

    public ScriptNode[] getRenditions(ScriptNode node, String mimeTypePrefix) {
        List<ChildAssociationRef> renditions = this.renditionService.getRenditions(node.getNodeRef(), mimeTypePrefix);
        ScriptNode[] results = new ScriptNode[renditions.size()];
        int i = 0;
        while (i < renditions.size()) {
            results[i] = new ScriptNode(renditions.get(i).getChildRef(), this.serviceRegistry);
            ++i;
        }
        return results;
    }

    public ScriptNode getRenditionByName(ScriptNode node, String renditionName) {
        QName qname = this.createQName(renditionName);
        ChildAssociationRef result = this.renditionService.getRenditionByName(node.getNodeRef(), qname);
        return result == null ? null : new ScriptNode(result.getChildRef(), this.serviceRegistry);
    }

    private QName createQName(String qnameString) {
        QName result = qnameString.startsWith(Character.toString('{')) ? QName.createQName((String)qnameString) : QName.createQName((String)qnameString, (NamespacePrefixResolver)this.serviceRegistry.getNamespaceService());
        return result;
    }
}

