/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.KeyException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.alfresco.encryption.DefaultEncryptor;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.encryption.KeyStoreKeyProviderTest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.Pair;

public class EncryptorTest
extends TestCase {
    private DefaultEncryptor encryptor;

    public void setUp() throws Exception {
        this.encryptor = new DefaultEncryptor((KeyProvider)KeyStoreKeyProviderTest.getTestKeyStoreProvider(), "DESede/CBC/PKCS5Padding", null);
        this.encryptor.init();
    }

    public void testBasicBytes_NoKey() {
        byte[] bytes = new byte[]{11, 12, 13};
        Pair encryptedPair = this.encryptor.encrypt("fluff", null, bytes);
        byte[] decrypted = this.encryptor.decrypt("fluff", (AlgorithmParameters)encryptedPair.getSecond(), (byte[])encryptedPair.getFirst());
        EncryptorTest.assertTrue((String)"Encryption round trip failed. ", (boolean)Arrays.equals(bytes, decrypted));
    }

    public void testBasicBytes_WithKey() {
        byte[] bytes = new byte[]{11, 12, 13};
        Pair encryptedPair = this.encryptor.encrypt("mykey1", null, bytes);
        byte[] decrypted = this.encryptor.decrypt("mykey1", (AlgorithmParameters)encryptedPair.getSecond(), (byte[])encryptedPair.getFirst());
        EncryptorTest.assertTrue((String)"Encryption round trip failed. ", (boolean)Arrays.equals(bytes, decrypted));
    }

    public void testBasicObject() {
        String testObject = "   This is a string, but will be serialized    ";
        Pair encryptedPair = this.encryptor.encryptObject("mykey2", null, (Object)testObject);
        Object output = this.encryptor.decryptObject("mykey2", (AlgorithmParameters)encryptedPair.getSecond(), (byte[])encryptedPair.getFirst());
        EncryptorTest.assertEquals((String)"Encryption round trip failed. ", (Object)testObject, (Object)output);
    }

    public void testSealedObject() {
        String testObject = "   This is a string, but will be serialized    ";
        Serializable sealedObject = this.encryptor.sealObject("mykey2", null, (Serializable)((Object)testObject));
        try {
            Serializable output = this.encryptor.unsealObject("mykey2", sealedObject);
            EncryptorTest.assertEquals((String)"Encryption round trip failed. ", (Object)testObject, (Object)output);
        }
        catch (KeyException e) {
            throw new AlfrescoRuntimeException("", (Throwable)e);
        }
    }
}

