/*
 * #%L
 * Alfresco Repository
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.repo.importer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.namespace.QName;

/**
 * Description of node to import.
 * 
 * @author David Caruana
 *
 */
public interface ImportNode
{
    /**
     * @return the parent context
     */
    public ImportParent getParentContext();

    /**
     * @return the type definition
     */
    public TypeDefinition getTypeDefinition();

    /**
     * @return is this a node reference
     */
    public boolean isReference();

    /**
     * @return the node ref
     */
    public NodeRef getNodeRef();

    /**
     * @return node uuid to create node with
     */
    public String getUUID();

    /**
     * @return the child name
     */
    public String getChildName();

    /**
     * Gets all properties for the node
     * 
     * @return the properties
     */
    public Map<QName, Serializable> getProperties();

    /**
     * Gets the property data type
     * 
     * @param propertyName
     *            name of property
     * @return data type of named property
     */
    public DataTypeDefinition getPropertyDataType(QName propertyName);

    /**
     * @return the aspects of this node
     */
    public Set<QName> getNodeAspects();

    /**
     * @return true => the node inherits permissions from its parent
     */
    public boolean getInheritPermissions();

    /**
     * @return the permissions applied to this node
     */
    public List<AccessPermission> getAccessControlEntries();

}
