/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.extensions.surf.util.I18NUtil;

public class TemplateServiceImplTest
extends BaseSpringTest {
    private static final String TEMPLATE_1 = "org/alfresco/repo/template/test_template1.ftl";
    private NodeRef root_node;
    private TemplateService templateService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;

    @Before
    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.templateService = (TemplateService)this.applicationContext.getBean("templateService");
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)this.applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        TemplateServiceImplTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        TemplateServiceImplTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        BaseNodeServiceTest.loadModel(this.applicationContext);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                StoreRef store = TemplateServiceImplTest.this.nodeService.createStore("workspace", "template_" + System.currentTimeMillis());
                TemplateServiceImplTest.this.root_node = TemplateServiceImplTest.this.nodeService.getRootNode(store);
                HashMap<QName, String> properties = new HashMap<QName, String>(11);
                properties.put(ContentModel.PROP_NAME, "subFolder");
                NodeRef subFolderRef = TemplateServiceImplTest.this.nodeService.createNode(TemplateServiceImplTest.this.root_node, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"subFolder")), ContentModel.TYPE_FOLDER, properties).getChildRef();
                properties.put(ContentModel.PROP_NAME, "subSubFolder");
                NodeRef subSubFolderRef = TemplateServiceImplTest.this.nodeService.createNode(subFolderRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"subSubFolder")), ContentModel.TYPE_FOLDER, properties).getChildRef();
                properties.put(ContentModel.PROP_NAME, "subSubSubFolder");
                TemplateServiceImplTest.this.nodeService.createNode(subSubFolderRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"subSubSubFolder")), ContentModel.TYPE_FOLDER, properties);
                BaseNodeServiceTest.buildNodeGraph(TemplateServiceImplTest.this.nodeService, TemplateServiceImplTest.this.root_node);
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    @Test
    public void testTemplates() {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Exception {
                TemplateServiceImplTest.assertNotNull((Object)TemplateServiceImplTest.this.templateService.getTemplateProcessor("freemarker"));
                Map model = TemplateServiceImplTest.this.createTemplateModel(TemplateServiceImplTest.this.root_node);
                String output = TemplateServiceImplTest.this.templateService.processTemplate("freemarker", TemplateServiceImplTest.TEMPLATE_1, (Object)model);
                TemplateServiceImplTest.assertTrue((String)"Cannot find root-node-id", (output.indexOf(TemplateServiceImplTest.this.root_node.getId()) != -1 ? 1 : 0) != 0);
                TemplateServiceImplTest.assertTrue((String)"Cannot resolve subFolder properly", (output.indexOf("root.childByNamePath[\"subFolder\"].name=subFolder") != -1 ? 1 : 0) != 0);
                TemplateServiceImplTest.assertTrue((String)"Cannot resolve subSubFolder properly", (output.indexOf("root.childByNamePath[\"subFolder/subSubFolder\"].name=subSubFolder") != -1 ? 1 : 0) != 0);
                TemplateServiceImplTest.assertTrue((String)"Cannot resolve subSubSubFolder properly", (output.indexOf("root.childByNamePath[\"subFolder/subSubFolder/subSubSubFolder\"].name=subSubSubFolder") != -1 ? 1 : 0) != 0);
                TemplateServiceImplTest.assertTrue((String)"Cannot resolve subSubSubFolder with enhancement properly", (output.indexOf("root.childByNamePath[\"subFolder\"].childByNamePath[\"subSubFolder/subSubSubFolder\"].name=subSubSubFolder") != -1 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    private Map createTemplateModel(NodeRef root) {
        HashMap<String, TemplateNode> model = new HashMap<String, TemplateNode>(7, 1.0f);
        model.put("root", new TemplateNode(root, this.serviceRegistry, null));
        return model;
    }

    @Test
    public void testGetTemplateProcessor() {
        TemplateServiceImplTest.assertNotNull((Object)this.templateService.getTemplateProcessor(null));
    }

    @Test
    public void testProcessTemplate() {
        Map model = this.createTemplateModel(this.root_node);
        StringWriter writer = new StringWriter();
        this.templateService.processTemplate(TEMPLATE_1, (Object)model, (Writer)writer);
        TemplateServiceImplTest.assertTrue((writer.toString().indexOf(this.root_node.getId()) != -1 ? 1 : 0) != 0);
        try {
            this.templateService.processTemplate("NOT_REAL", TEMPLATE_1, (Object)model, (Writer)new StringWriter());
            TemplateServiceImplTest.fail((String)"The engine name is nonsense");
        }
        catch (TemplateException templateException) {}
        try {
            this.templateService.processTemplate("NOT_REAL", TEMPLATE_1, (Object)model, I18NUtil.getLocale());
            TemplateServiceImplTest.fail((String)"The engine name is nonsense");
        }
        catch (TemplateException templateException) {}
        try {
            this.templateService.processTemplateString("NOT_REAL", TEMPLATE_1, (Object)model, (Writer)new StringWriter());
            TemplateServiceImplTest.fail((String)"The engine name is nonsense");
        }
        catch (TemplateException templateException) {}
    }
}

