/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail.script;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Scriptable;

public class ScriptThumbnail
extends ScriptNode {
    private static final long serialVersionUID = 7854749986083635678L;
    private static Log logger = LogFactory.getLog(ScriptThumbnail.class);

    public ScriptThumbnail(NodeRef nodeRef, ServiceRegistry services, Scriptable scope) {
        super(nodeRef, services, scope);
    }

    public void update() {
        List parentRefs = this.services.getNodeService().getParentAssocs(this.nodeRef, (QNamePattern)RenditionModel.ASSOC_RENDITION, RegexQNamePattern.MATCH_ALL);
        if (parentRefs.size() != 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("Node ").append(this.nodeRef).append(" has ").append(parentRefs.size()).append(" rendition parents. Unable to update.");
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg.toString());
            }
            throw new AlfrescoRuntimeException(msg.toString());
        }
        String name = ((ChildAssociationRef)parentRefs.get(0)).getQName().getLocalName();
        ThumbnailDefinition def = this.services.getThumbnailService().getThumbnailRegistry().getThumbnailDefinition(name);
        this.services.getThumbnailService().updateThumbnail(this.nodeRef, def.getTransformationOptions());
    }
}

