/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.util.Comparator;
import java.util.List;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.AbstractSiteMembership;
import org.alfresco.repo.site.SiteMembershipComparator;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.util.Pair;

@AlfrescoPublicApi
public class SiteGroupMembership
extends AbstractSiteMembership {
    private String displayName;

    public SiteGroupMembership(SiteInfo siteInfo, String id, String role, String displayName) {
        super(siteInfo, id, role);
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    static int compareTo(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs, SiteGroupMembership o1, SiteGroupMembership o2) {
        String displayName1 = o1.getDisplayName();
        String displayName2 = o2.getDisplayName();
        String siteRole1 = o1.getRole();
        String siteRole2 = o2.getRole();
        String shortName1 = o1.getSiteInfo().getShortName();
        String shortName2 = o2.getSiteInfo().getShortName();
        int groupName = SiteMembershipComparator.safeCompare(displayName1, displayName2);
        int siteRole = SiteMembershipComparator.safeCompare(siteRole1, siteRole2);
        int siteShortName = SiteMembershipComparator.safeCompare(shortName1, shortName2);
        if (siteRole == 0 && siteShortName == 0 && groupName == 0) {
            return 0;
        }
        return SiteMembershipComparator.compareSiteGroupsBody(sortPairs, displayName1, displayName2, siteRole1, siteRole2, groupName, siteRole, 0);
    }

    static Comparator<SiteGroupMembership> getComparator(List<Pair<?, CannedQuerySortDetails.SortOrder>> sortPairs) {
        return (o1, o2) -> SiteGroupMembership.compareTo(sortPairs, o1, o2);
    }
}

