/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.AlfrescoNetworkFile;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.alfresco.NetworkFileLegacyReferenceCount;
import org.alfresco.filesys.alfresco.RepositoryDiskInterface;
import org.alfresco.filesys.repo.AlfrescoFolder;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentComparator;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.filesys.repo.ContentNetworkFile;
import org.alfresco.filesys.repo.DotDotContentSearchContext;
import org.alfresco.filesys.repo.LinkMemoryNetworkFile;
import org.alfresco.filesys.repo.LockKeeper;
import org.alfresco.filesys.repo.NodeMonitor;
import org.alfresco.filesys.repo.NodeMonitorFactory;
import org.alfresco.filesys.repo.OpenFileMode;
import org.alfresco.filesys.repo.TempNetworkFile;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DirectoryNotEmptyException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.PermissionDeniedException;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class ContentDiskDriver2
extends AlfrescoDiskDriver
implements ExtendedDiskInterface,
DiskInterface,
DiskSizeInterface,
RepositoryDiskInterface,
OpLockInterface,
FileLockingInterface {
    private static final Log logger = LogFactory.getLog(ContentDiskDriver2.class);
    private static final Log readLogger = LogFactory.getLog((String)"org.alfresco.filesys.repo.ContentDiskDriver2.Read");
    private static final Log writeLogger = LogFactory.getLog((String)"org.alfresco.filesys.repo.ContentDiskDriver2.Write");
    private CifsHelper cifsHelper;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private PermissionService permissionService;
    private FileFolderService fileFolderService;
    private LockService lockService;
    private CheckOutCheckInService checkOutCheckInService;
    private AuthenticationContext authContext;
    private AuthenticationService authService;
    private BehaviourFilter policyBehaviourFilter;
    private NodeMonitorFactory m_nodeMonitorFactory;
    private ContentComparator contentComparator;
    private NodeArchiveService nodeArchiveService;
    private HiddenAspect hiddenAspect;
    private LockKeeper lockKeeper;
    private boolean isLockedFilesAsOffline;
    private static final String KEY_STORE = "store";
    private static final String KEY_ROOT_PATH = "rootPath";
    private static final String KEY_RELATIVE_PATH = "relativePath";

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"checkOutCheckInService", (Object)this.checkOutCheckInService);
        PropertyCheck.mandatory((Object)this, (String)"cifsHelper", (Object)this.cifsHelper);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"mimetypeService", (Object)this.mimetypeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"lockService", (Object)this.lockService);
        PropertyCheck.mandatory((Object)this, (String)"authContext", (Object)this.authContext);
        PropertyCheck.mandatory((Object)this, (String)"authService", (Object)this.authService);
        PropertyCheck.mandatory((Object)this, (String)"policyBehaviourFilter", (Object)this.policyBehaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"m_nodeMonitorFactory", (Object)this.m_nodeMonitorFactory);
        PropertyCheck.mandatory((Object)this, (String)"contentComparator", (Object)this.getContentComparator());
        PropertyCheck.mandatory((Object)this, (String)"nodeArchiveService", (Object)this.nodeArchiveService);
        PropertyCheck.mandatory((Object)this, (String)"hiddenAspect", (Object)this.hiddenAspect);
        PropertyCheck.mandatory((Object)this, (String)"lockKeeper", (Object)this.lockKeeper);
    }

    public final CifsHelper getCifsHelper() {
        return this.cifsHelper;
    }

    public final AuthenticationService getAuthenticationService() {
        return this.authService;
    }

    public final AuthenticationContext getAuthenticationContext() {
        return this.authContext;
    }

    public final NodeService getNodeService() {
        return this.nodeService;
    }

    public final ContentService getContentService() {
        return this.contentService;
    }

    public final NamespaceService getNamespaceService() {
        return this.namespaceService;
    }

    public final SearchService getSearchService() {
        return this.searchService;
    }

    public final FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public final PermissionService getPermissionService() {
        return this.permissionService;
    }

    public final LockService getLockService() {
        return this.lockService;
    }

    public BehaviourFilter getPolicyFilter() {
        return this.policyBehaviourFilter;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAuthenticationContext(AuthenticationContext authContext) {
        this.authContext = authContext;
    }

    public void setAuthenticationService(AuthenticationService authService) {
        this.authService = authService;
    }

    public void setFileFolderService(FileFolderService fileService) {
        this.fileFolderService = fileService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeMonitorFactory(NodeMonitorFactory nodeMonitorFactory) {
        this.m_nodeMonitorFactory = nodeMonitorFactory;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setPolicyFilter(BehaviourFilter policyFilter) {
        this.policyBehaviourFilter = policyFilter;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setAlfrescoLockKeeper(LockKeeper lockKeeper) {
        this.lockKeeper = lockKeeper;
    }

    public DeviceContext createContext(String deviceName, ConfigElement cfg) throws DeviceContextException {
        logger.error((Object)"Obsolete method called");
        throw new DeviceContextException("Obsolete Method called");
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        logger.debug((Object)"registerContext");
        super.registerContext(ctx);
        final ContentContext context = (ContentContext)ctx;
        final String rootPath = context.getRootPath();
        final String storeValue = context.getStoreName();
        AuthenticationUtil.RunAsWork<Void> runAsSystem = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                StoreRef storeRef = new StoreRef(storeValue);
                if (!ContentDiskDriver2.this.nodeService.exists(storeRef)) {
                    throw new DeviceContextException("Store not created prior to application startup: " + String.valueOf(storeRef));
                }
                NodeRef storeRootNodeRef = ContentDiskDriver2.this.nodeService.getRootNode(storeRef);
                List nodeRefs = ContentDiskDriver2.this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)ContentDiskDriver2.this.namespaceService, false);
                NodeRef rootNodeRef = null;
                if (nodeRefs.size() > 1) {
                    throw new DeviceContextException("Multiple possible roots for device: \n   root path: " + rootPath + "\n   results: " + String.valueOf(nodeRefs));
                }
                if (nodeRefs.size() == 0) {
                    throw new DeviceContextException("No root found for device: \n   root path: " + rootPath);
                }
                rootNodeRef = (NodeRef)nodeRefs.get(0);
                String relPath = context.getRelativePath();
                try {
                    if (relPath != null && relPath.length() > 0) {
                        NodeRef relPathNode = ContentDiskDriver2.this.cifsHelper.getNodeRef(rootNodeRef, relPath);
                        if (!ContentDiskDriver2.this.cifsHelper.isDirectory(relPathNode)) {
                            throw new DeviceContextException("Relative path is not a folder, " + relPath);
                        }
                        rootNodeRef = relPathNode;
                    } else if (!ContentDiskDriver2.this.cifsHelper.isDirectory(rootNodeRef)) {
                        throw new DeviceContextException("Root node is not a folder type node");
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Error during create context", (Throwable)ex);
                    }
                    throw new DeviceContextException("Unable to find root node.", (Throwable)ex);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("set root node ref:" + String.valueOf(rootNodeRef)));
                }
                context.setRootNodeRef(rootNodeRef);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsSystem, (String)AuthenticationUtil.getSystemUserName());
        if (context.getOfflineFiles()) {
            this.isLockedFilesAsOffline = true;
            logger.info((Object)"Locked files will be marked as offline");
        }
        logger.debug((Object)"initialise the node monitor");
        if (!context.getDisableNodeMonitor() && this.m_nodeMonitorFactory != null) {
            NodeMonitor nodeMonitor = this.m_nodeMonitorFactory.createNodeMonitor(context);
            context.setNodeMonitor(nodeMonitor);
        }
        logger.debug((Object)"initialise the file state lock manager");
        if (context.getDisableOplocks()) {
            logger.warn((Object)("Oplock support disabled for filesystem " + context.getDeviceName()));
        }
        if (context.hasQuotaManager()) {
            try {
                context.getQuotaManager().startManager((DiskInterface)this, (DiskDeviceContext)context);
                logger.info((Object)"Quota manager enabled for filesystem");
            }
            catch (QuotaManagerException ex) {
                logger.error((Object)"Failed to start quota manager", (Throwable)ex);
            }
        }
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"isReadOnly");
        }
        return !this.m_transactionService.getAllowWrite();
    }

    public org.alfresco.jlan.server.filesys.FileInfo getFileInformation(SrvSession session, TreeConnection tree, String path) throws IOException {
        boolean readOnly;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFileInformation:" + path + ", session:" + session.getUniqueId()));
        }
        ContentContext cfr_ignored_0 = (ContentContext)tree.getContext();
        boolean bl = readOnly = !this.m_transactionService.getAllowWrite();
        if (path == null || path.length() == 0) {
            path = "\\";
        }
        String infoPath = path;
        try {
            ContentFileInfo finfo = null;
            NodeRef nodeRef = this.getNodeForPath(tree, infoPath);
            if (nodeRef != null) {
                finfo = this.getCifsHelper().getFileInformation(nodeRef, readOnly, this.isLockedFilesAsOffline);
                if (path.equals("\\")) {
                    finfo.setFileName("");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getFileInformation found nodeRef for nodeRef :" + String.valueOf(nodeRef) + ", path: " + path));
                }
            }
            return finfo;
        }
        catch (FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Get file info - file not found, " + path));
            }
            throw e;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Get file info - access denied, " + path), (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Get file information " + path);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Get file info error" + path), (Throwable)ex);
            }
            throw new IOException("Get file information " + path, ex);
        }
    }

    public SearchContext startSearch(SrvSession session, TreeConnection tree, String searchPath, int attributes) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startSearch: " + searchPath + ", session:" + session.getUniqueId()));
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        try {
            long endTime;
            String searchFileSpec = searchPath;
            NodeRef searchRootNodeRef = ctx.getRootNode();
            String[] paths = FileName.splitPath((String)searchPath);
            String dotPath = paths[0];
            NodeRef dirNodeRef = this.getNodeForPath(tree, dotPath);
            if (dirNodeRef != null) {
                searchRootNodeRef = dirNodeRef;
                searchFileSpec = paths[1];
            }
            if (searchFileSpec.equals("*.*")) {
                searchFileSpec = "*";
            }
            long startTime = 0L;
            if (logger.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            logger.debug((Object)"Call repo to do search");
            List<NodeRef> results = this.getCifsHelper().getNodeRefs(searchRootNodeRef, searchFileSpec);
            if (logger.isDebugEnabled() && (endTime = System.currentTimeMillis()) - startTime > 500L) {
                logger.debug((Object)("Search for searchPath=" + searchPath + ", searchSpec=" + searchFileSpec + ", searchRootNode=" + String.valueOf(searchRootNodeRef) + " took " + (endTime - startTime) + "ms results=" + results.size()));
            }
            DotDotContentSearchContext searchCtx = new DotDotContentSearchContext(this.getCifsHelper(), results, searchFileSpec, paths[0], this.isLockedFilesAsOffline);
            ContentFileInfo dotInfo = this.getCifsHelper().getFileInformation(searchRootNodeRef, false, this.isLockedFilesAsOffline);
            if (searchPath.equals("\\")) {
                org.alfresco.jlan.server.filesys.FileInfo dotDotInfo = new org.alfresco.jlan.server.filesys.FileInfo();
                dotDotInfo.copyFrom((org.alfresco.jlan.server.filesys.FileInfo)dotInfo);
                searchCtx.setDotInfo(dotInfo);
                searchCtx.setDotDotInfo(dotDotInfo);
            } else {
                String[] parent = FileName.splitPath((String)dotPath);
                NodeRef parentNodeRef = this.getNodeForPath(tree, parent[0]);
                if (parentNodeRef != null) {
                    ContentFileInfo dotDotInfo = this.getCifsHelper().getFileInformation(parentNodeRef, false, this.isLockedFilesAsOffline);
                    searchCtx.setDotDotInfo(dotDotInfo);
                }
                searchCtx.setDotInfo(dotInfo);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started search: search path=" + searchPath + " attributes=" + attributes + ", ctx=" + String.valueOf(searchCtx)));
            }
            return searchCtx;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start search - access denied, " + searchPath));
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Exception in Start search", (Throwable)ex);
            }
            throw new FileNotFoundException("Start search " + searchPath);
        }
    }

    public int fileExists(SrvSession session, TreeConnection tree, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fileExists:" + name + ", session:" + session.getUniqueId()));
        }
        ContentContext cfr_ignored_0 = (ContentContext)tree.getContext();
        int status = -1;
        try {
            org.alfresco.jlan.server.filesys.FileInfo info = this.getFileInformation(session, tree, name);
            if (info.isDirectory()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"is directory");
                }
                status = 2;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"is file");
                }
                status = 1;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("File status determined: name=" + name + " status=" + status));
            }
            return status;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"file does not exist");
            }
            status = 0;
            return status;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("File exists error, " + name), (Throwable)e);
            }
            status = 0;
            return status;
        }
    }

    public NetworkFile openFile(SrvSession session, TreeConnection tree, FileOpenParams params) throws IOException {
        logger.error((Object)"Obsolete method called");
        throw new AlfrescoRuntimeException("obsolete method called");
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        logger.error((Object)"Obsolete method called");
        throw new AlfrescoRuntimeException("obsolete method called");
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createDirectory :" + String.valueOf(params)));
        }
        try {
            String folderName;
            NodeRef dirNodeRef;
            String path = params.getPath();
            String[] paths = FileName.splitPath((String)path);
            if (paths[0] != null && paths[0].length() > 1) {
                dirNodeRef = this.getNodeForPath(tree, paths[0]);
                folderName = paths[1];
            } else {
                dirNodeRef = ctx.getRootNode();
                folderName = path;
            }
            if (dirNodeRef == null) {
                throw new IOException("Create directory parent folder not found" + params.getFullPath());
            }
            NodeRef nodeRef = this.getCifsHelper().createNode(dirNodeRef, folderName, ContentModel.TYPE_FOLDER);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created directory: path=" + params.getPath() + " file open params=" + String.valueOf(params) + " node=" + String.valueOf(nodeRef)));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create directory - access denied, " + params.getFullPath()));
            }
            throw new AccessDeniedException("Create directory " + params.getFullPath());
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Create directory error", (Throwable)ex);
            }
            throw new IOException("Create directory " + params.getFullPath(), ex);
        }
    }

    public void deleteDirectory(SrvSession session, TreeConnection tree, String dir) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deleteDirectory: " + dir + ", session:" + session.getUniqueId()));
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        NodeRef deviceRootNodeRef = ctx.getRootNode();
        try {
            NodeRef nodeRef = this.getCifsHelper().getNodeRef(deviceRootNodeRef, dir);
            if (this.fileFolderService.exists(nodeRef)) {
                if (this.getCifsHelper().isFolderEmpty(nodeRef)) {
                    this.fileFolderService.delete(nodeRef);
                } else {
                    throw new DirectoryNotEmptyException(dir);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Deleted directory: directory=" + dir + " node=" + String.valueOf(nodeRef)));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delete directory - file not found, " + dir));
            }
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Delete directory - access denied, " + dir));
            }
            throw new AccessDeniedException("Delete directory, access denied :" + dir);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled() && ctx.hasDebug(1)) {
                logger.debug((Object)"Delete directory", (Throwable)ex);
            }
            throw new IOException("Delete directory " + dir, ex);
        }
    }

    public void flushFile(SrvSession session, TreeConnection tree, NetworkFile file) throws IOException {
        ContentContext cfr_ignored_0 = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Flush file=" + file.getFullName() + ", session:" + session.getUniqueId()));
        }
        file.flushFile();
    }

    public void closeFile(SrvSession session, TreeConnection tree, NetworkFile file) throws IOException {
        throw new AlfrescoRuntimeException("obsolete method called");
    }

    public void deleteFile(SrvSession session, TreeConnection tree, String name) throws IOException {
        throw new AlfrescoRuntimeException("obsolete method called");
    }

    @Override
    public NodeRef deleteFile2(SrvSession session, TreeConnection tree, NodeRef rootNode, String path) throws IOException {
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deleteFile:" + path + ", session:" + session.getUniqueId()));
        }
        try {
            QuotaManager quotaMgr = ctx.getQuotaManager();
            NodeRef nodeRef = this.getNodeForPath(tree, path);
            if (this.fileFolderService.exists(nodeRef)) {
                org.alfresco.jlan.server.filesys.FileInfo fInfo;
                this.lockKeeper.removeLock(nodeRef);
                org.alfresco.jlan.server.filesys.FileInfo fileInfo = fInfo = quotaMgr == null ? null : this.getFileInformation(session, tree, path);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("deleted file" + path));
                }
                this.fileFolderService.delete(nodeRef);
                if (quotaMgr != null) {
                    quotaMgr.releaseSpace(session, tree, fInfo.getFileId(), path, fInfo.getSize());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deleted file: " + path + ", nodeRef=" + String.valueOf(nodeRef)));
                }
                return nodeRef;
            }
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file - access denied (locked)", (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Unable to delete " + path);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file - access denied", (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("Unable to delete " + path);
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file error - pass through IO Exception", (Throwable)ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Delete file error", (Throwable)ex);
            }
            IOException ioe = new IOException("Delete file " + path);
            ioe.initCause(ex);
            throw ioe;
        }
        return null;
    }

    public void renameFile(SrvSession session, TreeConnection tree, String oldName, String newName) throws IOException {
        throw new AlfrescoRuntimeException("obsolete method called");
    }

    @Override
    public void renameFile(NodeRef rootNode, String oldName, String newName, boolean soft, boolean moveAsSystem) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RenameFile oldName=" + oldName + ", newName=" + newName + ", soft" + soft));
        }
        try {
            final NodeRef nodeToMoveRef = this.getCifsHelper().getNodeRef(rootNode, oldName);
            if (nodeToMoveRef != null && this.nodeService.getProperty(nodeToMoveRef, ContentModel.PROP_LINK_DESTINATION) != null) {
                throw new AccessDeniedException("Cannot rename link nodes");
            }
            String[] splitPaths = FileName.splitPath((String)newName);
            String[] oldPaths = FileName.splitPath((String)oldName);
            final NodeRef targetFolderRef = this.getCifsHelper().getNodeRef(rootNode, splitPaths[0]);
            final NodeRef sourceFolderRef = this.getCifsHelper().getNodeRef(rootNode, oldPaths[0]);
            final String name = splitPaths[1];
            boolean sameFolder = splitPaths[0].equalsIgnoreCase(oldPaths[0]);
            boolean isFolder = this.getCifsHelper().isDirectory(nodeToMoveRef);
            if (isFolder || !sameFolder) {
                if (sameFolder) {
                    this.fileFolderService.rename(nodeToMoveRef, name);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  Renamed " + (isFolder ? "folder" : "file") + ":   Old name:      " + oldName + "\n   New name:      " + newName + "\n"));
                    }
                } else {
                    if (moveAsSystem) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Run move as System for: " + oldName));
                        }
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                            public Object doWork() throws Exception {
                                return ContentDiskDriver2.this.fileFolderService.moveFrom(nodeToMoveRef, sourceFolderRef, targetFolderRef, name);
                            }
                        }, (String)AuthenticationUtil.getSystemUserName());
                    } else {
                        this.fileFolderService.moveFrom(nodeToMoveRef, sourceFolderRef, targetFolderRef, name);
                    }
                    logger.debug((Object)("Moved between different folders: \n   Old name:      " + oldName + "\n   New name:      " + newName + "\n   Source folder: " + String.valueOf(sourceFolderRef) + "\n   Target folder: " + String.valueOf(targetFolderRef) + "\n   Node:          " + String.valueOf(nodeToMoveRef) + "\n   Aspects:       " + String.valueOf(this.nodeService.getAspects(nodeToMoveRef))));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  Renamed " + (isFolder ? "folder" : "file") + " using " + (sameFolder ? "rename" : "move")));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rename file within same folder: \n   Old name:      " + oldName + "\n   New name:      " + newName + "\n   Source folder: " + String.valueOf(sourceFolderRef) + "\n   Target folder: " + String.valueOf(targetFolderRef) + "\n   Node:          " + String.valueOf(nodeToMoveRef) + "\n   Aspects:       " + String.valueOf(this.nodeService.getAspects(nodeToMoveRef))));
                }
                if (soft) {
                    logger.debug((Object)"this is a soft delete - use copy rather than rename");
                    this.fileFolderService.copy(nodeToMoveRef, null, name);
                    this.nodeService.addAspect(nodeToMoveRef, ContentModel.ASPECT_SOFT_DELETE, null);
                } else {
                    this.fileFolderService.rename(nodeToMoveRef, name);
                }
            }
        }
        catch (org.alfresco.service.cmr.model.FileNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rename file - about to throw file not exists exception file:" + oldName), (Throwable)e);
            }
            throw new FileNotFoundException("renameFile: file not found file: + oldName");
        }
        catch (FileExistsException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rename file - about to throw file exists exception", (Throwable)((Object)e));
            }
            throw new org.alfresco.jlan.server.filesys.FileExistsException(newName);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rename file - about to throw permissions denied exception", (Throwable)((Object)ex));
            }
            throw new PermissionDeniedException("renameFile: No permissions to rename file:" + oldName);
        }
        catch (NodeLockedException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rename file - about to throw access denied exception", (Throwable)((Object)ex));
            }
            throw new AccessDeniedException("renameFile:  Access Denied - Node locked file:" + oldName);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Rename file about to throw access denied exception", (Throwable)ex);
            }
            throw new AlfrescoRuntimeException("renameFile failed: \n   Old name:      " + oldName + "\n   New name:      " + newName + "\n" + String.valueOf((Object)ex));
        }
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, org.alfresco.jlan.server.filesys.FileInfo info) throws IOException {
        ContentContext cfr_ignored_0 = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setFileInformation name=" + name + ", info=" + String.valueOf(info)));
        }
        NetworkFile networkFile = info.getNetworkFile();
        try {
            NodeRef nodeRef = this.getNodeForPath(tree, name);
            if (this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("write access denied to :" + name));
                }
                throw new AccessDeniedException("No write access to " + name);
            }
            this.getPolicyFilter().disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            if (info.hasSetFlag(1024) && info.hasDeleteOnClose()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set Delete On Close for :" + name));
                }
                if (this.permissionService.hasPermission(nodeRef, "Delete") == AccessStatus.DENIED) {
                    throw new PermissionDeniedException("No delete access to :" + name);
                }
                this.lockService.checkForLock(nodeRef);
                if (this.fileFolderService.exists(nodeRef)) {
                    boolean isFolder = true;
                    ContentFileInfo cInfo = this.getCifsHelper().getFileInformation(nodeRef, false, this.isLockedFilesAsOffline);
                    if (cInfo != null && !cInfo.isDirectory()) {
                        isFolder = false;
                    }
                    if (isFolder && !this.getCifsHelper().isFolderEmpty(nodeRef)) {
                        throw new DirectoryNotEmptyException(name);
                    }
                }
            }
            if (info.hasSetFlag(4)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set attributes" + name + ", file attrs = " + info.getFileAttributes()));
                }
                if (info.isSystem()) {
                    logger.debug((Object)("Set system aspect (not yet implemented)" + name));
                }
                if (info.isTemporary()) {
                    logger.debug((Object)("Set temporary aspect (not yet implemented)" + name));
                }
                if (info.isHidden()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Set hidden aspect" + name));
                    }
                    this.hiddenAspect.hideNodeExplicit(nodeRef);
                } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_HIDDEN)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Reset hidden aspect" + name));
                    }
                    this.hiddenAspect.unhideExplicit(nodeRef);
                }
            }
            if (info.hasSetFlag(2) && logger.isDebugEnabled()) {
                logger.debug((Object)("Set allocation size" + name + info.getAllocationSize()));
            }
            if (info.hasSetFlag(1) && logger.isDebugEnabled()) {
                logger.debug((Object)("Set file size" + name + info.getSize()));
            }
            if (info.hasSetFlag(512) && logger.isDebugEnabled()) {
                logger.debug((Object)("Set Mode" + name + info.getMode()));
            }
            HashMap<QName, Date> auditableProps = new HashMap<QName, Date>(5);
            if (info.hasSetFlag(16) && info.hasCreationDateTime()) {
                Date createDate = new Date(info.getCreationDateTime());
                auditableProps.put(ContentModel.PROP_CREATED, createDate);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set creation date" + name + ", " + String.valueOf(createDate)));
                }
            }
            if (info.hasSetFlag(8) && info.hasModifyDateTime()) {
                Date modifyDate = new Date(info.getModifyDateTime());
                auditableProps.put(ContentModel.PROP_MODIFIED, modifyDate);
                if (networkFile != null && !networkFile.isReadOnly()) {
                    networkFile.setModifyDate(info.getModifyDateTime());
                    if (networkFile instanceof TempNetworkFile) {
                        TempNetworkFile tnf = (TempNetworkFile)networkFile;
                        tnf.setModificationDateSetDirectly(true);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set modification date" + name + ", " + String.valueOf(modifyDate)));
                }
            }
            if (info.hasSetFlag(64) && info.hasChangeDateTime()) {
                Date changeDate = new Date(info.getChangeDateTime());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set change date (Not implemented)" + name + ", " + String.valueOf(changeDate)));
                }
            }
            if (info.hasSetFlag(32) && info.hasAccessDateTime()) {
                Date accessDate = new Date(info.getAccessDateTime());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set access date (Not implemented)" + name + ", " + String.valueOf(accessDate)));
                }
            }
            if (auditableProps.size() > 0) {
                this.getPolicyFilter().disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                this.nodeService.addProperties(nodeRef, auditableProps);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set auditable props: " + String.valueOf(auditableProps) + " file=" + name));
                }
            }
            return;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set file information - access denied, " + name));
            }
            throw new AccessDeniedException("Set file information " + name);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Set file information " + name, ex);
        }
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long size) throws IOException {
        FileState fstate;
        NetworkFileLegacyReferenceCount contentFile;
        ContentContext ctx = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("truncateFile file:" + String.valueOf(file) + ", size: " + size));
        }
        long allocSize = 0L;
        long releaseSize = 0L;
        QuotaManager quotaMgr = ctx.getQuotaManager();
        if (ctx.hasQuotaManager()) {
            if (file instanceof ContentNetworkFile) {
                contentFile = (ContentNetworkFile)file;
                if (!((ContentNetworkFile)contentFile).hasContent()) {
                    ((ContentNetworkFile)contentFile).openContent(false, false);
                }
            } else if (!(file instanceof TempNetworkFile)) {
                throw new IOException("Invalid file class type, " + file.getClass().getName());
            }
            if (size > file.getFileSize()) {
                allocSize = size - file.getFileSize();
                quotaMgr.allocateSpace(sess, tree, file, allocSize);
            } else {
                releaseSize = file.getFileSize() - size;
            }
        }
        if (file instanceof ContentNetworkFile && (fstate = ((AlfrescoNetworkFile)((Object)(contentFile = (ContentNetworkFile)file))).getFileState()) != null && size > fstate.getAllocationSize()) {
            fstate.setAllocationSize(size);
        }
        if (file instanceof TempNetworkFile && (fstate = ((TempNetworkFile)(contentFile = (TempNetworkFile)file)).getFileState()) != null && size > fstate.getAllocationSize()) {
            fstate.setAllocationSize(size);
        }
        try {
            file.truncateFile(size);
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("unable to truncate the file + :" + file.getFullName()), (Throwable)ex);
            }
            if (allocSize > 0L && quotaMgr != null) {
                quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, allocSize);
            }
            throw ex;
        }
        if (releaseSize > 0L && quotaMgr != null) {
            quotaMgr.releaseSpace(sess, tree, file.getFileId(), null, releaseSize);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Truncated file: network file=" + String.valueOf(file) + " size=" + size));
        }
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferPosition, int size, long fileOffset) throws IOException {
        if (readLogger.isDebugEnabled()) {
            readLogger.debug((Object)("read File:" + String.valueOf(file) + ", size" + size));
        }
        if (file.isDirectory()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"read file called for a directory - throw AccessDeniedException");
            }
            throw new AccessDeniedException("read called for a directory");
        }
        int count = file.readFile(buffer, size, bufferPosition, fileOffset);
        if (count == -1) {
            count = 0;
        }
        if (readLogger.isDebugEnabled()) {
            readLogger.debug((Object)("Read bytes from file: network file=" + String.valueOf(file) + " buffer size=" + buffer.length + " buffer pos=" + bufferPosition + " size=" + size + " file offset=" + fileOffset + " bytes read=" + count));
        }
        return count;
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"seek File");
        }
        if (file.isDirectory()) {
            throw new AccessDeniedException();
        }
        return file.seekFile(pos, typ);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buffer, int bufferOffset, int size, long fileOffset) throws IOException {
        if (writeLogger.isDebugEnabled()) {
            writeLogger.debug((Object)("write File:" + String.valueOf(file) + " size:" + size));
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        QuotaManager quotaMgr = ctx.getQuotaManager();
        long curSize = file.getFileSize();
        if (quotaMgr != null) {
            long extendSize = 0L;
            long endOfWrite = fileOffset + (long)size;
            if (endOfWrite > curSize) {
                TempNetworkFile tnf;
                FileState fstate;
                extendSize = endOfWrite - file.getFileSize();
                if (writeLogger.isDebugEnabled()) {
                    writeLogger.debug((Object)("writeFile: allocate more space fileName:" + file.getName() + ", extendTo:" + extendSize));
                }
                long alloc = quotaMgr.allocateSpace(sess, tree, file, extendSize);
                if (file instanceof TempNetworkFile && (fstate = (tnf = (TempNetworkFile)file).getFileState()) != null) {
                    fstate.setAllocationSize(alloc);
                }
            }
        }
        file.writeFile(buffer, size, bufferOffset, fileOffset);
        if (quotaMgr != null && file.getFileSize() < curSize) {
            quotaMgr.releaseSpace(sess, tree, file.getFileId(), file.getFullName(), curSize - file.getFileSize());
        }
        if (writeLogger.isDebugEnabled()) {
            writeLogger.debug((Object)("Wrote bytes to file: network file=" + String.valueOf(file) + " buffer size=" + buffer.length + " size=" + size + " file offset=" + fileOffset));
        }
        return size;
    }

    private NodeRef getNodeForPath(TreeConnection tree, String path) throws FileNotFoundException {
        ContentContext ctx = (ContentContext)tree.getContext();
        return this.getCifsHelper().getNodeRef(ctx.getRootNode(), path);
    }

    public NodeRef getNodeForPath(NodeRef rootNode, String path) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getNodeRefForPath:" + path));
        }
        return this.getCifsHelper().getNodeRef(rootNode, path);
    }

    private String getPathForNode(NodeRef rootNode, NodeRef nodeRef) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getPathForNode:" + String.valueOf(nodeRef)));
        }
        List<FileInfo> linkPaths = null;
        try {
            linkPaths = this.fileFolderService.getNamePath(rootNode, nodeRef);
        }
        catch (org.alfresco.service.cmr.model.FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException();
        }
        StringBuilder pathStr = new StringBuilder();
        for (FileInfo fInfo : linkPaths) {
            pathStr.append('\\');
            pathStr.append(fInfo.getName());
        }
        return pathStr.toString();
    }

    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        AlfrescoContext alfCtx = (AlfrescoContext)tree.getContext();
        return alfCtx.getLockManager();
    }

    public void getDiskInformation(DiskDeviceContext ctx, SrvDiskInfo diskDev) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getDiskInformation");
        }
        diskDev.setBlockSize(512);
        diskDev.setBlocksPerAllocationUnit(64L);
        long freeSpace = this.contentService.getStoreFreeSpace();
        long totalSpace = this.contentService.getStoreTotalSpace();
        if (totalSpace == -1L) {
            totalSpace = 0x10000000000L;
            freeSpace = 0x8000000000L;
        }
        diskDev.setTotalUnits(totalSpace / 32768L);
        diskDev.setFreeUnits(freeSpace / 32768L);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getDiskInformation returning diskDev:" + String.valueOf(diskDev)));
        }
    }

    public void setCifsHelper(CifsHelper cifsHelper) {
        this.cifsHelper = cifsHelper;
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
    }

    public void setCheckOutCheckInService(CheckOutCheckInService service) {
        this.checkOutCheckInService = service;
    }

    public final CheckOutCheckInService getCheckOutCheckInService() {
        return this.checkOutCheckInService;
    }

    @Override
    public void copyContent(NodeRef rootNode, String fromPath, String toPath) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copyContent from:" + fromPath + " to:" + toPath));
        }
        NodeRef sourceNodeRef = this.getNodeForPath(rootNode, fromPath);
        NodeRef targetNodeRef = this.getNodeForPath(rootNode, toPath);
        Serializable prop = this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_CONTENT);
        if (prop != null) {
            ContentData data;
            if (prop instanceof ContentData && (data = (ContentData)prop).getMimetype().equalsIgnoreCase("application/octet-stream")) {
                Serializable targetProp;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"mimetype is binary - guess mimetype has failed");
                }
                if ((targetProp = this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_CONTENT)) != null && targetProp instanceof ContentData) {
                    ContentData targetData = (ContentData)targetProp;
                    logger.debug((Object)"copy the existing mimetype");
                    prop = ContentData.setMimetype((ContentData)data, (String)targetData.getMimetype());
                }
            }
            this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_CONTENT, prop);
        } else {
            logger.debug((Object)"no content to save");
            ContentWriter writer = this.contentService.getWriter(targetNodeRef, ContentModel.PROP_CONTENT, true);
            writer.putContent("");
        }
    }

    @Override
    public NetworkFile createFile(NodeRef rootNode, String path, long allocationSize, boolean isHidden) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createFile :" + path));
        }
        try {
            String folderName;
            NodeRef dirNodeRef;
            String[] paths = FileName.splitPath((String)path);
            if (paths[0] != null && paths[0].length() > 1) {
                dirNodeRef = this.getNodeForPath(rootNode, paths[0]);
                folderName = paths[1];
            } else {
                dirNodeRef = rootNode;
                folderName = path;
            }
            boolean soft = false;
            NodeRef existing = this.fileFolderService.searchSimple(dirNodeRef, folderName);
            if (existing != null && this.nodeService.hasAspect(existing, ContentModel.ASPECT_SOFT_DELETE)) {
                logger.debug((Object)"existing node has soft delete aspect");
                soft = true;
            }
            NodeRef nodeRef = null;
            if (soft) {
                nodeRef = existing;
            } else {
                nodeRef = this.cifsHelper.createNode(dirNodeRef, folderName, ContentModel.TYPE_CONTENT);
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_NO_CONTENT, null);
                this.lockKeeper.addLock(nodeRef);
            }
            if (isHidden) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set hidden aspect, nodeRef:" + String.valueOf(nodeRef)));
                }
                this.hiddenAspect.hideNodeExplicit(nodeRef);
            }
            File file = TempFileProvider.createTempFile((String)"cifs", (String)".bin");
            TempNetworkFile netFile = new TempNetworkFile(file, path);
            netFile.setChanged(true);
            Serializable created = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CREATED);
            if (created != null && created instanceof Date) {
                Date d = (Date)created;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("replacing create date to date:" + String.valueOf(d)));
                }
                netFile.setCreationDate(d.getTime());
                netFile.setModifyDate(d.getTime());
            }
            netFile.setGrantedAccess(3);
            netFile.setAllowedAccess(3);
            if (netFile != null) {
                long id = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
                netFile.setFileId((int)(id & 0xFFFFFFFFL));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created file: path=" + path + " node=" + String.valueOf(nodeRef) + " network file=" + String.valueOf(netFile)));
            }
            return netFile;
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create file - access denied, " + path));
            }
            throw new AccessDeniedException("Unable to create file " + path);
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create file - content I/O error, " + path));
            }
            throw ex;
        }
        catch (ContentIOException contentIOException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Create file - content I/O error, " + path));
            }
            throw new DiskFullException("Unable to create file " + path);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Create file error", (Throwable)ex);
            }
            throw new IOException("Unable to create file " + path, ex);
        }
    }

    @Override
    public NetworkFile openFile(SrvSession session, TreeConnection tree, NodeRef rootNode, String path, OpenFileMode mode, boolean truncate) throws IOException {
        ContentContext cfr_ignored_0 = (ContentContext)tree.getContext();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("openFile :" + path + ", mode:" + String.valueOf((Object)mode)));
        }
        try {
            NetworkFileStateInterface netFile;
            NodeRef nodeRef;
            block38: {
                NodeRef linkRef;
                block36: {
                    ContentFileInfo fileInfo;
                    String name;
                    block37: {
                        name = path;
                        nodeRef = this.getNodeForPath(rootNode, path);
                        boolean readOnly = false;
                        switch (mode) {
                            case READ_ONLY: 
                            case ATTRIBUTES_ONLY: {
                                if (this.permissionService.hasPermission(nodeRef, "Read") == AccessStatus.DENIED) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("about to throw an no read access denied exception path:" + path));
                                    }
                                    throw new AccessDeniedException("No read access to " + path);
                                }
                                readOnly = true;
                                break;
                            }
                            case WRITE_ONLY: 
                            case READ_WRITE: {
                                if (!this.m_transactionService.getAllowWrite()) {
                                    throw new AccessDeniedException("Repo is write only, No write access to " + path);
                                }
                                if (this.permissionService.hasPermission(nodeRef, "Write") == AccessStatus.DENIED) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("about to throw an no write access denied exception path:" + path));
                                    }
                                    throw new AccessDeniedException("No write access to " + path);
                                }
                                this.lockService.checkForLock(nodeRef);
                                readOnly = false;
                                break;
                            }
                            case DELETE: {
                                if (!this.m_transactionService.getAllowWrite()) {
                                    throw new AccessDeniedException("Repo is write only, No write access to " + path);
                                }
                                this.lockService.checkForLock(nodeRef);
                            }
                        }
                        linkRef = (NodeRef)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LINK_DESTINATION);
                        netFile = null;
                        if (linkRef != null) break block36;
                        fileInfo = this.cifsHelper.getFileInformation(nodeRef, "", false, false);
                        if (!fileInfo.isDirectory()) break block37;
                        logger.debug((Object)"open file - is a directory!");
                        netFile = new AlfrescoFolder(path, fileInfo, readOnly);
                        break block38;
                    }
                    switch (ContentDiskDriver2.$SWITCH_TABLE$org$alfresco$filesys$repo$OpenFileMode()[mode.ordinal()]) {
                        case 1: {
                            logger.debug((Object)"open file for read only");
                            netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.getCifsHelper(), nodeRef, path, true, false, session);
                            netFile.setGrantedAccess(1);
                            break;
                        }
                        case 3: {
                            ContentReader reader;
                            logger.debug((Object)"open file for read write");
                            File file = TempFileProvider.createTempFile((String)"cifs", (String)".bin");
                            this.lockKeeper.addLock(nodeRef);
                            if (!truncate && (reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT)) != null) {
                                reader.getContent(file);
                            }
                            netFile = new TempNetworkFile(file, name);
                            netFile.setCreationDate(fileInfo.getCreationDateTime());
                            netFile.setModifyDate(fileInfo.getModifyDateTime());
                            netFile.setGrantedAccess(3);
                            if (truncate) {
                                netFile.truncateFile(0L);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Created file: path=" + name + " node=" + String.valueOf(nodeRef) + " network file=" + String.valueOf(netFile)));
                                break;
                            }
                            break block38;
                        }
                        case 5: {
                            logger.debug((Object)"open file for attributes only");
                            netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.getCifsHelper(), nodeRef, path, true, true, session);
                            netFile.setGrantedAccess(1);
                            break;
                        }
                        case 4: {
                            logger.debug((Object)"open file for delete");
                            netFile = ContentNetworkFile.createFile(this.nodeService, this.contentService, this.mimetypeService, this.getCifsHelper(), nodeRef, path, true, false, session);
                            netFile.setGrantedAccess(1);
                            break;
                        }
                        case 2: {
                            logger.debug((Object)"open file write only");
                            File file = TempFileProvider.createTempFile((String)"cifs", (String)".bin");
                            netFile = new TempNetworkFile(file, name);
                            netFile.setGrantedAccess(3);
                            if (!logger.isDebugEnabled()) break block38;
                            logger.debug((Object)("Created temporary file: path=" + name + " node=" + String.valueOf(nodeRef) + " network file=" + String.valueOf(netFile)));
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block38;
                }
                String srvName = null;
                SMBServer cifsServer = (SMBServer)session.getServer().getConfiguration().findServer("CIFS");
                if (session instanceof SMBSrvSession) {
                    SMBSrvSession smbSess = (SMBSrvSession)session;
                    srvName = smbSess.getShareHostName();
                } else {
                    srvName = cifsServer != null ? cifsServer.getServerName() : InetAddress.getLocalHost().getHostName();
                }
                String pathl = this.getPathForNode(rootNode, linkRef);
                path = pathl.replace('\\', '/');
                String lnkForWinPath = this.convertStringToUnicode(path);
                StringBuilder urlStr = new StringBuilder();
                urlStr.append("[InternetShortcut]\r\n");
                urlStr.append("URL=file://");
                urlStr.append(srvName);
                urlStr.append("/");
                urlStr.append(tree.getSharedDevice().getName());
                urlStr.append(lnkForWinPath);
                urlStr.append("\r\n");
                byte[] urlData = urlStr.toString().getBytes();
                ContentFileInfo fInfo = this.getCifsHelper().getFileInformation(nodeRef, false, this.isLockedFilesAsOffline);
                fInfo.setFileSize(urlData.length);
                netFile = new LinkMemoryNetworkFile(fInfo.getFileName(), urlData, fInfo, nodeRef);
                netFile.setFullName(pathl);
            }
            if (netFile != null) {
                long id = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
                netFile.setFileId((int)(id & 0xFFFFFFFFL));
                netFile.setClosed(false);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Opened network file: path=" + path + " network file=" + String.valueOf(netFile)));
            }
            return netFile;
        }
        catch (NodeLockedException nodeLockedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Open file - node is locked, " + path));
            }
            throw new AccessDeniedException("File is locked, no write access to " + path);
        }
        catch (org.alfresco.repo.security.permissions.AccessDeniedException accessDeniedException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Open file - access denied, " + path));
            }
            throw new AccessDeniedException("Open file " + path);
        }
        catch (AlfrescoRuntimeException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Open file error", (Throwable)ex);
            }
            throw new IOException("Open file " + path, ex);
        }
    }

    private String convertStringToUnicode(String str) {
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else if (ch > '\u00ff') {
                ostr.append(ch);
            } else {
                ostr.append("%");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                hex.length();
                int j = 0;
                while (j < 2 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    @Override
    public NodeRef closeFile(TreeConnection tree, NodeRef rootNode, String path, NetworkFile file) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Close file:" + path + ", readOnly=" + file.isReadOnly()));
        }
        if (file.hasDeleteOnClose()) {
            NodeRef target = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("closeFile has delete on close set path:" + path));
            }
            try {
                target = this.getCifsHelper().getNodeRef(rootNode, path);
                if (target != null) {
                    this.nodeService.deleteNode(target);
                }
            }
            catch (org.alfresco.repo.security.permissions.AccessDeniedException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Delete file from close file- access denied", (Throwable)((Object)ex));
                }
                throw new AccessDeniedException("Unable to delete " + path);
            }
            file.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Closed file: network file=" + String.valueOf(file) + " delete on close=" + file.hasDeleteOnClose()));
            }
            return target;
        }
        if (file instanceof TempNetworkFile) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Got a temp network file to close path:" + path));
            }
            TempNetworkFile tempFile = (TempNetworkFile)file;
            NodeRef target = this.getCifsHelper().getNodeRef(rootNode, tempFile.getFullName());
            this.lockKeeper.removeLock(target);
            if (this.nodeService.hasAspect(target, ContentModel.ASPECT_NO_CONTENT)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"removed no content aspect");
                }
                this.nodeService.removeAspect(target, ContentModel.ASPECT_NO_CONTENT);
            }
            if (tempFile.isChanged()) {
                tempFile.flushFile();
                tempFile.close();
                boolean contentChanged = true;
                ContentReader existingContent = this.contentService.getReader(target, ContentModel.PROP_CONTENT);
                if (existingContent != null) {
                    existingContent.getSize();
                    existingContent.getMimetype();
                    contentChanged = this.isContentChanged(existingContent, tempFile);
                    if (file.getFileSize() > 0L && existingContent.getSize() == 0L && this.nodeService.hasAspect(target, ContentModel.ASPECT_VERSIONABLE)) {
                        this.getPolicyFilter().disableBehaviour(target, ContentModel.ASPECT_VERSIONABLE);
                    }
                }
                if (contentChanged) {
                    String encoding;
                    logger.debug((Object)"content has changed, need to create a new content item");
                    this.getPolicyFilter().disableBehaviour(target, ContentModel.ASPECT_AUDITABLE);
                    this.nodeService.setProperty(target, ContentModel.PROP_MODIFIER, (Serializable)((Object)this.authService.getCurrentUserName()));
                    if (tempFile.isModificationDateSetDirectly()) {
                        logger.debug((Object)"modification date set directly");
                        this.nodeService.setProperty(target, ContentModel.PROP_MODIFIED, (Serializable)new Date(tempFile.getModifyDate()));
                    } else {
                        logger.debug((Object)"modification date not set directly");
                        this.nodeService.setProperty(target, ContentModel.PROP_MODIFIED, (Serializable)new Date());
                    }
                    String mimetype = this.mimetypeService.guessMimetype(tempFile.getFullName(), (ContentReader)new FileContentReader(tempFile.getFile()));
                    logger.debug((Object)("guesssed mimetype:" + mimetype));
                    if (mimetype.equalsIgnoreCase("application/octet-stream") && existingContent != null) {
                        mimetype = existingContent.getMimetype();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("using mimetype of existing content :" + mimetype));
                        }
                    }
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(tempFile.getFile()));
                    try {
                        ContentCharsetFinder charsetFinder = this.mimetypeService.getContentCharsetFinder();
                        Charset charset = charsetFinder.getCharset((InputStream)is, mimetype);
                        encoding = charset.name();
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    ContentWriter writer = this.contentService.getWriter(target, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype(mimetype);
                    writer.setEncoding(encoding);
                    writer.putContent(tempFile.getFile());
                }
            }
        }
        try {
            file.close();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Closed file: network file=" + String.valueOf(file) + " delete on close=" + file.hasDeleteOnClose() + ", write count" + file.getWriteCount()));
                if (!file.hasDeleteOnClose() && file instanceof ContentNetworkFile) {
                    ContentNetworkFile cFile = (ContentNetworkFile)file;
                    logger.debug((Object)("  File " + file.getFullName() + ", version=" + String.valueOf(this.nodeService.getProperty(cFile.getNodeRef(), ContentModel.PROP_VERSION_LABEL))));
                }
            }
            return null;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exception in closeFile - path:" + path), (Throwable)e);
            }
            throw new IOException("Unable to closeFile :" + path + e.toString(), e);
        }
        catch (Error e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Exception in closeFile - path:" + path), (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void reduceQuota(SrvSession session, TreeConnection tree, NetworkFile file) {
        if (file.hasDeleteOnClose()) {
            ContentContext ctx = (ContentContext)tree.getContext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"closeFile has delete on close set");
            }
            if (file instanceof TempNetworkFile) {
                TempNetworkFile tnf = (TempNetworkFile)file;
                QuotaManager quotaMgr = ctx.getQuotaManager();
                if (quotaMgr != null) {
                    try {
                        quotaMgr.releaseSpace(session, tree, file.getFileId(), file.getName(), (long)tnf.getFileSizeInt());
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    @Override
    public void deleteEmptyFile(NodeRef rootNode, String path) {
        block3: {
            try {
                NodeRef target = this.getCifsHelper().getNodeRef(rootNode, path);
                if (target != null && this.nodeService.hasAspect(target, ContentModel.ASPECT_NO_CONTENT)) {
                    this.nodeService.deleteNode(target);
                }
            }
            catch (IOException ne) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Unable to delete empty file:" + path), (Throwable)ne);
            }
        }
    }

    public OpLockManager getOpLockManager(SrvSession sess, TreeConnection tree) {
        AlfrescoContext alfCtx = (AlfrescoContext)tree.getContext();
        return alfCtx.getOpLockManager();
    }

    public boolean isOpLocksEnabled(SrvSession sess, TreeConnection tree) {
        return this.getOpLockManager(sess, tree) != null;
    }

    private boolean isContentChanged(ContentReader existingContent, TempNetworkFile newFile) {
        return !this.contentComparator.isContentEqual(existingContent, newFile.getFile());
    }

    public void setContentComparator(ContentComparator contentComparator) {
        this.contentComparator = contentComparator;
    }

    public ContentComparator getContentComparator() {
        return this.contentComparator;
    }

    @Override
    public NetworkFile restoreFile(SrvSession sess, TreeConnection tree, NodeRef rootNode, String path, long allocationSize, NodeRef originalNodeRef) throws IOException {
        NodeRef archivedNodeRef;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("restore node:" + String.valueOf(originalNodeRef) + ", path:" + path));
        }
        if (this.nodeService.exists(archivedNodeRef = this.getNodeArchiveService().getArchivedNode(originalNodeRef))) {
            NodeRef restoredNodeRef = this.nodeService.restoreNode(archivedNodeRef, null, null, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("node has been restored nodeRef," + String.valueOf(restoredNodeRef) + ", path " + path));
            }
            return this.openFile(sess, tree, rootNode, path, OpenFileMode.READ_WRITE, true);
        }
        return this.createFile(rootNode, path, allocationSize, false);
    }

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    public NodeArchiveService getNodeArchiveService() {
        return this.nodeArchiveService;
    }

    private static interface DiskSizeInterfaceConsts {
        public static final int DiskBlockSize = 512;
        public static final long DiskAllocationUnit = 32768L;
        public static final long DiskBlocksPerUnit = 64L;
        public static final long DiskSizeDefault = 0x10000000000L;
        public static final long DiskFreeDefault = 0x8000000000L;
    }
}

