/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rawevents;

import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.EventBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rawevents.AbstractEventProducer;
import org.alfresco.repo.rawevents.TransactionAwareEventProducer;
import org.alfresco.repo.rawevents.types.Event;
import org.alfresco.repo.rawevents.types.EventType;
import org.alfresco.repo.rawevents.types.OnContentUpdatePolicyEvent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class EventBehaviourTest
extends BaseSpringTest {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/EventBehaviourTest";
    @Autowired
    private RetryingTransactionHelper retryingTransactionHelper;
    @Autowired
    private ContentService contentService;
    @Autowired
    private PolicyComponent policyComponent;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private AuthenticationComponent authenticationComponent;
    private NodeRef rootNodeRef;
    private NodeRef contentNodeRef;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private TransactionAwareEventProducer eventProducer;
    private boolean policyFired = false;
    private boolean newContent = true;

    @Before
    public void setUp() throws Exception {
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {}
    }

    private void validateSetUp() {
        EventBehaviourTest.assertNotNull((Object)this.contentService);
        EventBehaviourTest.assertNotNull((Object)this.nodeService);
        EventBehaviourTest.assertNotNull((Object)this.rootNodeRef);
        EventBehaviourTest.assertNotNull((Object)this.contentNodeRef);
        EventBehaviourTest.assertNotNull((Object)this.camelContext);
        EventBehaviourTest.assertNotNull((Object)this.eventProducer);
    }

    private void setupTestData() {
        StoreRef storeRef = new StoreRef("workspace", ((Object)((Object)this)).getClass().getName());
        if (!this.nodeService.exists(storeRef)) {
            storeRef = this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        ContentData contentData = new ContentData(null, "text/plain", 0L, "UTF-16", Locale.CHINESE);
        PropertyMap properties = new PropertyMap();
        properties.put((Object)ContentModel.PROP_CONTENT, (Object)contentData);
        ChildAssociationRef assocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)TEST_NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_CONTENT, (Map)properties);
        this.contentNodeRef = assocRef.getChildRef();
        this.validateSetUp();
    }

    @Test
    public void onContentUpdatePolicyFirstEventNF() throws Exception {
        this.policyFired = false;
        String endpointUri = this.getMockEndpointUri();
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(endpointUri, MockEndpoint.class);
        mockEndpoint.setAssertPeriod(500L);
        this.retryingTransactionHelper.doInTransaction(() -> {
            BehaviourDefinition classBehaviour = null;
            try {
                this.setupTestData();
                EventBehaviour eventBehaviour = new EventBehaviour((AbstractEventProducer)this.eventProducer, endpointUri, (Object)this, "createOnContentUpdateEvent", Behaviour.NotificationFrequency.FIRST_EVENT);
                classBehaviour = this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.ASPECT_VERSIONABLE, (Behaviour)eventBehaviour);
                ContentWriter contentWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.putContent("content update one");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                this.newContent = false;
                this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("content update two");
                EventBehaviourTest.assertTrue((boolean)this.policyFired);
                this.policyFired = false;
                ContentWriter contentWriter3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
                contentWriter3.putContent("content update three");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter4 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter4.putContent("content update four");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                mockEndpoint.setExpectedCount(0);
                mockEndpoint.assertIsSatisfied();
            }
            catch (Throwable throwable) {
                if (classBehaviour != null) {
                    this.policyComponent.removeClassDefinition(classBehaviour);
                }
                throw throwable;
            }
            if (classBehaviour != null) {
                this.policyComponent.removeClassDefinition(classBehaviour);
            }
            return null;
        });
        mockEndpoint.setExpectedCount(1);
        mockEndpoint.assertIsSatisfied();
    }

    @Test
    public void onContentUpdatePolicyEveryEventNF() throws Exception {
        this.policyFired = false;
        String endpointUri = this.getMockEndpointUri();
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(endpointUri, MockEndpoint.class);
        mockEndpoint.setAssertPeriod(500L);
        this.retryingTransactionHelper.doInTransaction(() -> {
            BehaviourDefinition classBehaviour = null;
            try {
                this.setupTestData();
                EventBehaviour eventBehaviour = new EventBehaviour((AbstractEventProducer)this.eventProducer, endpointUri, (Object)this, "createOnContentUpdateEvent", Behaviour.NotificationFrequency.EVERY_EVENT);
                classBehaviour = this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.ASPECT_VERSIONABLE, (Behaviour)eventBehaviour);
                ContentWriter contentWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.putContent("content update one");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                this.newContent = false;
                this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("content update two");
                EventBehaviourTest.assertTrue((boolean)this.policyFired);
                this.policyFired = false;
                ContentWriter contentWriter3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
                contentWriter3.putContent("content update three");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter4 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter4.putContent("content update four");
                EventBehaviourTest.assertTrue((boolean)this.policyFired);
                this.policyFired = false;
                try {
                    eventBehaviour.disable();
                    ContentWriter contentWriter5 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                    contentWriter5.putContent("content update five");
                    EventBehaviourTest.assertFalse((boolean)this.policyFired);
                }
                finally {
                    eventBehaviour.enable();
                }
                mockEndpoint.setExpectedCount(0);
                mockEndpoint.assertIsSatisfied();
            }
            catch (Throwable throwable) {
                if (classBehaviour != null) {
                    this.policyComponent.removeClassDefinition(classBehaviour);
                }
                throw throwable;
            }
            if (classBehaviour != null) {
                this.policyComponent.removeClassDefinition(classBehaviour);
            }
            return null;
        });
        mockEndpoint.setExpectedCount(2);
        mockEndpoint.assertIsSatisfied();
    }

    @Test
    public void onContentUpdatePolicyTxnCommitNF() throws Exception {
        this.policyFired = false;
        String endpointUri = this.getMockEndpointUri();
        MockEndpoint mockEndpoint = (MockEndpoint)this.camelContext.getEndpoint(endpointUri, MockEndpoint.class);
        mockEndpoint.setAssertPeriod(500L);
        this.retryingTransactionHelper.doInTransaction(() -> {
            BehaviourDefinition classBehaviour = null;
            try {
                this.setupTestData();
                EventBehaviour eventBehaviour = new EventBehaviour((AbstractEventProducer)this.eventProducer, endpointUri, (Object)this, "createOnContentUpdateEvent", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
                classBehaviour = this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.ASPECT_VERSIONABLE, (Behaviour)eventBehaviour);
                ContentWriter contentWriter = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter.putContent("content update one");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                this.newContent = false;
                this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("content update two");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                ContentWriter contentWriter3 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, false);
                contentWriter3.putContent("content update three");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                this.nodeService.addAspect(this.contentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter4 = this.contentService.getWriter(this.contentNodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter4.putContent("content update four");
                EventBehaviourTest.assertFalse((boolean)this.policyFired);
                mockEndpoint.setExpectedCount(0);
                mockEndpoint.assertIsSatisfied();
            }
            catch (Throwable throwable) {
                if (classBehaviour != null) {
                    this.policyComponent.removeClassDefinition(classBehaviour);
                }
                throw throwable;
            }
            if (classBehaviour != null) {
                this.policyComponent.removeClassDefinition(classBehaviour);
            }
            return null;
        });
        mockEndpoint.setExpectedCount(1);
        mockEndpoint.assertIsSatisfied();
    }

    private String getMockEndpointUri() {
        return "mock:" + ((Object)((Object)this)).getClass().getSimpleName() + "_" + GUID.generate();
    }

    public Event createOnContentUpdateEvent(NodeRef nodeRef, boolean newContent) {
        EventBehaviourTest.assertEquals((Object)this.contentNodeRef, (Object)nodeRef);
        EventBehaviourTest.assertEquals((boolean)this.newContent, (boolean)newContent);
        EventBehaviourTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE));
        this.policyFired = true;
        long timestamp = System.currentTimeMillis();
        OnContentUpdatePolicyEvent event = new OnContentUpdatePolicyEvent();
        event.setType(EventType.CONTENT_UPDATED.toString());
        event.setTimestamp(Long.valueOf(timestamp));
        event.setNodeRef(nodeRef.toString());
        event.setNewContent(newContent);
        return event;
    }
}

