/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingCorrespondingNodeResolverImpl
implements CorrespondingNodeResolver {
    private static final Log log = LogFactory.getLog(CachingCorrespondingNodeResolverImpl.class);
    private Map<NodeRef, CorrespondingNodeResolver.ResolvedParentChildPair> cache = new HashMap<NodeRef, CorrespondingNodeResolver.ResolvedParentChildPair>(359);
    private CorrespondingNodeResolver delegateResolver;

    public CachingCorrespondingNodeResolverImpl() {
    }

    public CachingCorrespondingNodeResolverImpl(CorrespondingNodeResolver delegateResolver) {
        this.delegateResolver = delegateResolver;
    }

    @Override
    public CorrespondingNodeResolver.ResolvedParentChildPair resolveCorrespondingNode(NodeRef sourceNodeRef, ChildAssociationRef primaryAssoc, Path parentPath) {
        CorrespondingNodeResolver.ResolvedParentChildPair result = this.cache.get(sourceNodeRef);
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found fully-resolved entry in cache for node " + String.valueOf(sourceNodeRef)));
            }
            return result;
        }
        result = this.delegateResolver.resolveCorrespondingNode(sourceNodeRef, primaryAssoc, parentPath);
        if (result.resolvedChild != null && result.resolvedParent != null) {
            this.cache.put(sourceNodeRef, result);
        }
        return result;
    }

    public void setDelegateResolver(CorrespondingNodeResolver delegateResolver) {
        this.delegateResolver = delegateResolver;
    }
}

