/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.script;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JSPropertyExtractor {
    private StringBuilder getCapitalisedPropertyName(String name) {
        StringBuilder capitalisedPropertyName = new StringBuilder();
        capitalisedPropertyName.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            capitalisedPropertyName.append(name.substring(1));
        }
        return capitalisedPropertyName;
    }

    boolean propertyExists(String propertyName, Object jsObject) {
        return this.resolveMethod(propertyName, jsObject) != null;
    }

    Object extractProperty(String propertyName, Object jsObject) {
        Method resolvedMethod = this.resolveMethod(propertyName, jsObject);
        if (resolvedMethod == null) {
            return null;
        }
        try {
            Object propertyValue = resolvedMethod.invoke(jsObject, new Object[0]);
            return propertyValue;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private Method resolveMethod(String propertyName, Object jsObject) {
        StringBuilder capitalisedPropertyName = this.getCapitalisedPropertyName(propertyName);
        String nameOfPotentialGetMethod = "get" + capitalisedPropertyName;
        String nameOfPotentialIsMethod = "is" + capitalisedPropertyName;
        Method[] availableMethods = jsObject.getClass().getMethods();
        Method resolvedMethod = null;
        Method[] methodArray = availableMethods;
        int n = availableMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (resolvedMethod == null && nameOfPotentialIsMethod.equals(method.getName()) && method.getParameterTypes().length == 0) {
                resolvedMethod = method;
            }
            if (nameOfPotentialGetMethod.equals(method.getName()) && method.getParameterTypes().length == 0) {
                resolvedMethod = method;
                break;
            }
            ++n2;
        }
        return resolvedMethod;
    }
}

