/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import javax.sql.DataSource;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.domain.dialect.MySQLInnoDBDialect;
import org.alfresco.repo.domain.dialect.PostgreSQLDialect;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.schemacomp.ExportDb;
import org.alfresco.util.schemacomp.test.exportdb.AbstractExportTester;
import org.alfresco.util.schemacomp.test.exportdb.MySQLDialectExportTester;
import org.alfresco.util.schemacomp.test.exportdb.PostgreSQLDialectExportTester;
import org.alfresco.util.testing.category.DBTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class ExportDbTest {
    private ApplicationContext ctx;
    private ExportDb exporter;
    private Dialect dialect;
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private PlatformTransactionManager tx;
    private AbstractExportTester exportTester;
    private static final Log logger = LogFactory.getLog(ExportDbTest.class);

    @Before
    public void setUp() throws Exception {
        this.ctx = ApplicationContextHelper.getApplicationContext();
        this.dataSource = (DataSource)this.ctx.getBean("dataSource");
        this.tx = (PlatformTransactionManager)this.ctx.getBean("transactionManager");
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.exporter = new ExportDb(this.ctx);
        this.exporter.setNamePrefix("export_test_");
        this.dialect = (Dialect)this.ctx.getBean("dialect");
    }

    @Test
    public void exportDb() throws Exception {
        Class<?> dialectClass = this.dialect.getClass();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using dialect class " + dialectClass.getName()));
        }
        if (PostgreSQLDialect.class.isAssignableFrom(dialectClass)) {
            this.exportTester = new PostgreSQLDialectExportTester(this.exporter, this.tx, this.jdbcTemplate);
        } else if (MySQLInnoDBDialect.class.isAssignableFrom(dialectClass)) {
            this.exportTester = new MySQLDialectExportTester(this.exporter, this.tx, this.jdbcTemplate);
        }
        if (this.exportTester != null) {
            this.exportTester.runExportTest();
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("Unsupported dialect for this test " + dialectClass.getName()));
        }
    }
}

