/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PropertyMapTest {
    private static Map<QName, Serializable> beforeTestMap;
    private static Map<QName, Serializable> afterTestMap;

    @BeforeClass
    public static void initTestMaps() {
        beforeTestMap = new HashMap<QName, Serializable>();
        afterTestMap = new HashMap<QName, Serializable>();
        beforeTestMap.put(ContentModel.PROP_NAME, (Serializable)((Object)"willBeChanged"));
        beforeTestMap.put(ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"willBeNulled"));
        beforeTestMap.put(ContentModel.PROP_TITLE, (Serializable)((Object)"willBeRemoved"));
        beforeTestMap.put(ContentModel.PROP_COUNTER, (Serializable)((Object)"unchanging"));
        afterTestMap.put(ContentModel.PROP_NAME, (Serializable)((Object)"hasBeenChanged"));
        afterTestMap.put(ContentModel.PROP_ADDRESSEE, null);
        afterTestMap.put(ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"hasBeenAdded"));
        afterTestMap.put(ContentModel.PROP_COUNTER, (Serializable)((Object)"unchanging"));
    }

    @Test
    public void propertiesAdded() throws Exception {
        HashMap<QName, String> expected = new HashMap<QName, String>();
        expected.put(ContentModel.PROP_DESCRIPTION, "hasBeenAdded");
        Assert.assertEquals(expected, (Object)PropertyMap.getAddedProperties(beforeTestMap, afterTestMap));
    }

    @Test
    public void propertiesChanged() throws Exception {
        HashMap<QName, String> expected = new HashMap<QName, String>();
        expected.put(ContentModel.PROP_NAME, "hasBeenChanged");
        expected.put(ContentModel.PROP_ADDRESSEE, null);
        Assert.assertEquals(expected, (Object)PropertyMap.getChangedProperties(beforeTestMap, afterTestMap));
    }

    @Test
    public void propertiesRemoved() throws Exception {
        HashMap<QName, String> expected = new HashMap<QName, String>();
        expected.put(ContentModel.PROP_TITLE, "willBeRemoved");
        Assert.assertEquals(expected, (Object)PropertyMap.getRemovedProperties(beforeTestMap, afterTestMap));
    }

    @Test
    public void propertiesUnchanged() throws Exception {
        HashMap<QName, String> expected = new HashMap<QName, String>();
        expected.put(ContentModel.PROP_COUNTER, "unchanging");
        Assert.assertEquals(expected, (Object)PropertyMap.getUnchangedProperties(beforeTestMap, afterTestMap));
    }

    @Test
    public void nullMapsShouldntCauseExceptions() throws Exception {
        Assert.assertEquals(Collections.emptyMap(), (Object)PropertyMap.getAddedProperties(null, null));
        Assert.assertEquals(Collections.emptyMap(), (Object)PropertyMap.getRemovedProperties(null, null));
        Assert.assertEquals(Collections.emptyMap(), (Object)PropertyMap.getChangedProperties(null, null));
        Assert.assertEquals(Collections.emptyMap(), (Object)PropertyMap.getUnchangedProperties(null, null));
    }
}

