/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.VirtualProtocol;
import org.alfresco.repo.virtual.template.BasicConstraint;
import org.alfresco.repo.virtual.template.FilesFoldersConstraint;
import org.alfresco.repo.virtual.template.IgnoreConstraint;
import org.alfresco.repo.virtual.template.SortConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class VirtualQueryImplTest
extends TestCase {
    private static final String QUERY_TEST_STRING_QUERY = "QUERY_TEST_STRING_QUERY";
    private static final String TEST_LOCAL_NAME_1 = "testQName1";
    private static final String TEST_LOCAL_NAME_2 = "testQName2";
    private static final String TEST_URI = "http://test/uri";
    private static final String TST_PREFIX = "tst";
    private VirtualQueryImpl query;
    private ActualEnvironment mockitoActualEnvironment;
    private NamespacePrefixResolver mockitoPrefixResolver;
    private QName testQName1;
    private QName testQName2;
    private Reference nodeOneReference;

    protected void setUp() throws Exception {
        super.setUp();
        this.query = new VirtualQueryImpl(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.toString(), "fts-alfresco", QUERY_TEST_STRING_QUERY);
        this.mockitoActualEnvironment = (ActualEnvironment)Mockito.mock(ActualEnvironment.class);
        Mockito.when((Object)this.mockitoActualEnvironment.query((SearchParameters)Mockito.any(SearchParameters.class))).thenReturn((Object)new EmptyResultSet());
        this.mockitoPrefixResolver = (NamespacePrefixResolver)Mockito.mock(NamespacePrefixResolver.class);
        Mockito.when((Object)this.mockitoPrefixResolver.getNamespaceURI(TST_PREFIX)).thenReturn((Object)TEST_URI);
        Mockito.when((Object)this.mockitoPrefixResolver.getPrefixes(TEST_URI)).thenReturn(Arrays.asList(TST_PREFIX));
        Mockito.when((Object)this.mockitoActualEnvironment.getNamespacePrefixResolver()).thenReturn((Object)this.mockitoPrefixResolver);
        this.testQName1 = QName.createQName((String)TST_PREFIX, (String)TEST_LOCAL_NAME_1, (NamespacePrefixResolver)this.mockitoPrefixResolver);
        this.testQName2 = QName.createQName((String)TST_PREFIX, (String)TEST_LOCAL_NAME_2, (NamespacePrefixResolver)this.mockitoPrefixResolver);
        NodeRef n1 = new NodeRef("workspace://SpacesStore/17c8f11d-0936-4295-88a0-12b85764c76f");
        NodeRef n2 = new NodeRef("workspace://SpacesStore/27c8f11d-0936-4295-88a0-12b85764c76f");
        this.nodeOneReference = ((VirtualProtocol)Protocols.VIRTUAL.protocol).newReference(n1, "/1", n2);
    }

    @Test
    public void testPerform_1() throws Exception {
        Pair withSortDefinitions = new Pair((Object)this.testQName2, (Object)true);
        BasicConstraint constraint = BasicConstraint.INSTANCE;
        constraint = new FilesFoldersConstraint((VirtualQueryConstraint)constraint, true, true);
        constraint = new IgnoreConstraint((VirtualQueryConstraint)constraint, Collections.singleton(this.testQName2), Collections.singleton(this.testQName1));
        constraint = new SortConstraint((VirtualQueryConstraint)constraint, Arrays.asList(withSortDefinitions));
        this.query.perform(this.mockitoActualEnvironment, (VirtualQueryConstraint)constraint, null, this.nodeOneReference);
        this.assertPerform1Results((Pair<QName, Boolean>)withSortDefinitions);
    }

    public void testPerform_2() throws Exception {
        BasicConstraint constraint = BasicConstraint.INSTANCE;
        constraint = new FilesFoldersConstraint((VirtualQueryConstraint)constraint, false, true);
        constraint = new IgnoreConstraint((VirtualQueryConstraint)constraint, Collections.singleton(this.testQName2), Collections.singleton(this.testQName1));
        this.query.perform(this.mockitoActualEnvironment, (VirtualQueryConstraint)constraint, null, this.nodeOneReference);
        this.assertPerform2Results();
    }

    private void assertPerform1Results(Pair<QName, Boolean> withSortDefinitions) {
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        ((ActualEnvironment)Mockito.verify((Object)this.mockitoActualEnvironment)).query((SearchParameters)queryCaptor.capture());
        VirtualQueryImplTest.assertEquals((String)"(QUERY_TEST_STRING_QUERY) and !ASPECT:'tst:testQName1' and !TYPE:'tst:testQName2'", (String)((SearchParameters)queryCaptor.getValue()).getQuery());
        ArrayList sortDefinitions = ((SearchParameters)queryCaptor.getValue()).getSortDefinitions();
        VirtualQueryImplTest.assertNotNull((Object)sortDefinitions);
        VirtualQueryImplTest.assertEquals((int)1, (int)sortDefinitions.size());
        VirtualQueryImplTest.assertEquals((String)((QName)withSortDefinitions.getFirst()).getPrefixString(), (String)((SearchParameters.SortDefinition)sortDefinitions.get(0)).getField());
        VirtualQueryImplTest.assertEquals((Object)withSortDefinitions.getSecond(), (Object)((SearchParameters.SortDefinition)sortDefinitions.get(0)).isAscending());
    }

    @Test
    public void testPerform_deprecated_1() {
        Pair withSortDefinitions = new Pair((Object)this.testQName2, (Object)true);
        this.query.perform(this.mockitoActualEnvironment, true, true, null, Collections.emptySet(), Collections.singleton(this.testQName2), Collections.singleton(this.testQName1), Arrays.asList(withSortDefinitions), null, this.nodeOneReference);
        this.assertPerform1Results((Pair<QName, Boolean>)withSortDefinitions);
    }

    @Test
    public void testPerform_deprecated_2() {
        this.query.perform(this.mockitoActualEnvironment, false, true, null, Collections.emptySet(), Collections.singleton(this.testQName2), Collections.singleton(this.testQName1), Collections.emptyList(), null, this.nodeOneReference);
        this.assertPerform2Results();
    }

    private void assertPerform2Results() {
        ArgumentCaptor queryCaptor = ArgumentCaptor.forClass(SearchParameters.class);
        ((ActualEnvironment)Mockito.verify((Object)this.mockitoActualEnvironment)).query((SearchParameters)queryCaptor.capture());
        VirtualQueryImplTest.assertEquals((String)"((QUERY_TEST_STRING_QUERY) and TYPE:\"cm:folder\") and !ASPECT:'tst:testQName1' and !TYPE:'tst:testQName2'", (String)((SearchParameters)queryCaptor.getValue()).getQuery());
        ArrayList sortDefinitions = ((SearchParameters)queryCaptor.getValue()).getSortDefinitions();
        VirtualQueryImplTest.assertNotNull((Object)sortDefinitions);
        VirtualQueryImplTest.assertEquals((int)0, (int)sortDefinitions.size());
    }
}

