/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParentAssocsInfo
implements Serializable {
    private static final long serialVersionUID = -2167221525380802365L;
    private static final Log logger = LogFactory.getLog(ParentAssocsInfo.class);
    private static Set<Long> warnedDuplicateParents = new HashSet<Long>(3);
    private final boolean isRoot;
    private final boolean isStoreRoot;
    private final Long primaryAssocId;
    private final Map<Long, ChildAssocEntity> parentAssocsById;

    ParentAssocsInfo(boolean isRoot, boolean isStoreRoot, ChildAssocEntity parent) {
        this(isRoot, isStoreRoot, Collections.singletonList(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ParentAssocsInfo(boolean isRoot, boolean isStoreRoot, List<? extends ChildAssocEntity> parents) {
        this.isRoot = isRoot;
        this.isStoreRoot = isStoreRoot;
        Long primaryAssocId = null;
        TreeMap<Long, ChildAssocEntity> parentAssocsById = new TreeMap<Long, ChildAssocEntity>();
        for (ChildAssocEntity childAssocEntity : parents) {
            Long parentAssocId = childAssocEntity.getId();
            parentAssocsById.put(parentAssocId, childAssocEntity);
            if (!childAssocEntity.isPrimary().booleanValue()) continue;
            if (primaryAssocId == null) {
                primaryAssocId = parentAssocId;
                continue;
            }
            Set<Long> set = warnedDuplicateParents;
            synchronized (set) {
                Long childNodeId = childAssocEntity.getChildNode().getId();
                boolean added = warnedDuplicateParents.add(childNodeId);
                if (added) {
                    logger.warn((Object)("Multiple primary associations: \n   Node:         " + String.valueOf(childNodeId) + "\n   Associations: " + String.valueOf(parents)));
                }
            }
        }
        this.primaryAssocId = primaryAssocId;
        this.parentAssocsById = Collections.unmodifiableMap(parentAssocsById);
    }

    private ParentAssocsInfo(boolean isRoot, boolean isStoreRoot, Map<Long, ChildAssocEntity> parentAssocsById, Long primaryAssocId) {
        this.isRoot = isRoot;
        this.isStoreRoot = isStoreRoot;
        this.parentAssocsById = Collections.unmodifiableMap(parentAssocsById);
        this.primaryAssocId = primaryAssocId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ParentAssocsInfo ").append("[isRoot=").append(this.isRoot).append(", isStoreRoot=").append(this.isStoreRoot).append(", parentAssocsById=").append(this.parentAssocsById).append(", primaryAssocId=").append(this.primaryAssocId).append("]");
        return builder.toString();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isStoreRoot() {
        return this.isStoreRoot;
    }

    public Map<Long, ChildAssocEntity> getParentAssocs() {
        return this.parentAssocsById;
    }

    public ChildAssocEntity getPrimaryParentAssoc() {
        return this.primaryAssocId != null ? this.parentAssocsById.get(this.primaryAssocId) : null;
    }

    public ParentAssocsInfo changeIsRoot(boolean isRoot) {
        return new ParentAssocsInfo(isRoot, this.isRoot, this.parentAssocsById, this.primaryAssocId);
    }

    public ParentAssocsInfo changeIsStoreRoot(boolean isStoreRoot) {
        return new ParentAssocsInfo(this.isRoot, isStoreRoot, this.parentAssocsById, this.primaryAssocId);
    }

    public ParentAssocsInfo addAssoc(Long assocId, ChildAssocEntity parentAssoc) {
        HashMap<Long, ChildAssocEntity> parentAssocs = new HashMap<Long, ChildAssocEntity>(this.parentAssocsById);
        parentAssocs.put(parentAssoc.getId(), parentAssoc);
        return new ParentAssocsInfo(this.isRoot, this.isStoreRoot, parentAssocs, this.primaryAssocId);
    }

    public ParentAssocsInfo removeAssoc(Long assocId) {
        HashMap<Long, ChildAssocEntity> parentAssocs = new HashMap<Long, ChildAssocEntity>(this.parentAssocsById);
        parentAssocs.remove(assocId);
        return new ParentAssocsInfo(this.isRoot, this.isStoreRoot, parentAssocs, this.primaryAssocId);
    }
}

