/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

public class ConfigurationChecker
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(ConfigurationChecker.class);
    private static final String WARN_RELATIVE_DIR_ROOT = "system.config_check.warn.dir_root";
    private static final String MSG_DIR_ROOT = "system.config_check.msg.dir_root";
    private static final String ERR_MISSING_CONTENT = "system.config_check.err.missing_content";
    static final String ERR_FIX_DIR_ROOT = "system.config_check.err.fix_dir_root";
    static final String WARN_STARTING_WITH_ERRORS = "system.config_check.warn.starting_with_errors";
    private boolean strict;
    private String dirRoot;
    private ImporterBootstrap systemBootstrap;
    private TransactionService transactionService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private SearchService searchService;
    private ContentService contentService;

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("ConfigurationChecker");
        return sb.toString();
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setDirRoot(String dirRoot) {
        this.dirRoot = dirRoot;
    }

    public void setSystemBootstrap(ImporterBootstrap systemBootstrap) {
        this.systemBootstrap = systemBootstrap;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> checkWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                return AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() {
                        ConfigurationChecker.this.check();
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(checkWork, true);
    }

    private void check() {
        ContentReader reader;
        boolean isRelativeRoot;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting bootstrap configuration check: " + String.valueOf((Object)this)));
        }
        if (isRelativeRoot = this.dirRoot.startsWith(".")) {
            String msg = I18NUtil.getMessage((String)WARN_RELATIVE_DIR_ROOT, (Object[])new Object[]{this.dirRoot});
            logger.warn((Object)msg);
        }
        File dirRootFile = new File(this.dirRoot);
        String msgDirRoot = I18NUtil.getMessage((String)MSG_DIR_ROOT, (Object[])new Object[]{dirRootFile});
        logger.info((Object)msgDirRoot);
        boolean versionPropertiesContentAvailable = true;
        NodeRef descriptorNodeRef = this.getSystemDescriptor();
        if (descriptorNodeRef != null && (reader = this.contentService.getReader(descriptorNodeRef, ContentModel.PROP_SYS_VERSION_PROPERTIES)) != null && !reader.exists()) {
            versionPropertiesContentAvailable = false;
            String msg = I18NUtil.getMessage((String)ERR_MISSING_CONTENT, (Object[])new Object[]{reader.getContentUrl()});
            logger.error((Object)msg);
        }
        if (!versionPropertiesContentAvailable) {
            String msg = I18NUtil.getMessage((String)ERR_FIX_DIR_ROOT, (Object[])new Object[]{dirRootFile});
            logger.error((Object)msg);
            if (this.strict) {
                throw new AlfrescoRuntimeException(msg);
            }
            String warn = I18NUtil.getMessage((String)WARN_STARTING_WITH_ERRORS);
            logger.warn((Object)warn);
        }
    }

    public NodeRef getSystemDescriptor() {
        StoreRef systemStoreRef = this.systemBootstrap.getStoreRef();
        List nodeRefs = null;
        if (this.nodeService.exists(systemStoreRef)) {
            Properties systemProperties = this.systemBootstrap.getConfiguration();
            String path = systemProperties.getProperty("system.descriptor.current.childname");
            String searchPath = "/" + path;
            NodeRef rootNodeRef = this.nodeService.getRootNode(systemStoreRef);
            nodeRefs = this.searchService.selectNodes(rootNodeRef, searchPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            if (nodeRefs.size() > 0) {
                NodeRef descriptorNodeRef = (NodeRef)nodeRefs.get(0);
                return descriptorNodeRef;
            }
        }
        return null;
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

