/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.Map;
import java.util.Properties;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetConfig;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SolrFacetConfigTest {
    private static ClassPathXmlApplicationContext context;
    private static Properties rawProperties;
    private static SolrFacetConfig facetConfig;

    @BeforeClass
    public static void setUp() throws Exception {
        context = new ClassPathXmlApplicationContext(new String[]{"classpath:facets/test-facet-property-context.xml"}, ApplicationContextHelper.getApplicationContext());
        rawProperties = (Properties)context.getBean("solrFacetRawPropertiesTest", Properties.class);
        facetConfig = (SolrFacetConfig)context.getBean("solrFacetConfigsTest", SolrFacetConfig.class);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        context.close();
    }

    @Test
    public void testBasic() throws Exception {
        SolrFacetConfig config = null;
        try {
            config = new SolrFacetConfig(null, "");
            Assert.fail((String)"Null properties should have been detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            config = new SolrFacetConfig(rawProperties, null);
            Assert.fail((String)"Null properties should have been detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        config = new SolrFacetConfig(rawProperties, "default,custom");
        config.setNamespaceService((NamespaceService)context.getBean("namespaceService", NamespaceService.class));
        try {
            config.getDefaultFacets();
            Assert.fail((String)"Initialization should be done.");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Test
    public void testDefault() throws Exception {
        Map defaultProps = facetConfig.getDefaultFacets();
        Assert.assertNotNull((Object)defaultProps);
        Assert.assertEquals((String)"Incorrect number of properties", (long)6L, (long)defaultProps.size());
        SolrFacetProperties contentSizeFP = (SolrFacetProperties)defaultProps.get("test_filter_content_size");
        Assert.assertEquals((String)"Incorrect QNAME", (Object)"{http://www.alfresco.org/model/content/1.0}content.size", (Object)contentSizeFP.getFacetQName().toString());
        Assert.assertEquals((Object)"faceted-search.facet-menu.facet.size", (Object)contentSizeFP.getDisplayName());
        Assert.assertEquals((Object)"alfresco/search/FacetFilters", (Object)contentSizeFP.getDisplayControl());
        Assert.assertEquals((long)5L, (long)contentSizeFP.getMaxFilters());
        Assert.assertEquals((long)1L, (long)contentSizeFP.getHitThreshold());
        Assert.assertEquals((long)4L, (long)contentSizeFP.getMinFilterValueLength());
        Assert.assertEquals((Object)"ALPHABETICALLY", (Object)contentSizeFP.getSortBy());
        Assert.assertEquals((Object)"ALL", (Object)contentSizeFP.getScope());
        Assert.assertEquals((long)0L, (long)contentSizeFP.getScopedSites().size());
        Assert.assertEquals((Object)true, (Object)contentSizeFP.isEnabled());
        Assert.assertEquals((long)1L, (long)contentSizeFP.getCustomProperties().size());
        String customValue = (String)((Object)((SolrFacetProperties.CustomProperties)contentSizeFP.getCustomProperties().iterator().next()).getValue());
        Assert.assertTrue((boolean)Boolean.valueOf(customValue));
        SolrFacetProperties mimeTypeFP = (SolrFacetProperties)defaultProps.get("test_filter_mimetype");
        Assert.assertEquals((String)"Incorrect QNAME", (Object)"{http://www.alfresco.org/model/content/1.0}content.mimetype", (Object)mimeTypeFP.getFacetQName().toString());
        Assert.assertEquals((Object)"faceted-search.facet-menu.facet.formats", (Object)mimeTypeFP.getDisplayName());
        Assert.assertEquals((Object)"alfresco/search/FacetFilters", (Object)mimeTypeFP.getDisplayControl());
        Assert.assertEquals((long)5L, (long)mimeTypeFP.getMaxFilters());
        Assert.assertEquals((long)1L, (long)mimeTypeFP.getHitThreshold());
        Assert.assertEquals((long)4L, (long)mimeTypeFP.getMinFilterValueLength());
        Assert.assertEquals((Object)"DESCENDING", (Object)mimeTypeFP.getSortBy());
        Assert.assertEquals((Object)"ALL", (Object)mimeTypeFP.getScope());
        Assert.assertEquals((long)0L, (long)mimeTypeFP.getScopedSites().size());
        Assert.assertEquals((Object)true, (Object)mimeTypeFP.isEnabled());
        SolrFacetProperties siteFP = (SolrFacetProperties)defaultProps.get("site_filter");
        Assert.assertEquals((String)"There shouldn't be any namespace (solr special).", (Object)"{}SITE", (Object)siteFP.getFacetQName().toString());
        Assert.assertEquals((Object)"SiteExtDisplayName", (Object)siteFP.getDisplayName());
        Assert.assertEquals((Object)"alfresco/search/FacetFilters", (Object)siteFP.getDisplayControl());
        Assert.assertEquals((long)20L, (long)siteFP.getMaxFilters());
        Assert.assertEquals((long)1L, (long)siteFP.getHitThreshold());
        Assert.assertEquals((long)1L, (long)siteFP.getMinFilterValueLength());
        Assert.assertEquals((Object)"ALPHABETICALLY", (Object)siteFP.getSortBy());
        Assert.assertEquals((Object)"ALL", (Object)siteFP.getScope());
        Assert.assertEquals((long)0L, (long)siteFP.getScopedSites().size());
        Assert.assertEquals((Object)true, (Object)siteFP.isEnabled());
        SolrFacetProperties tagFP = (SolrFacetProperties)defaultProps.get("tag_filter");
        Assert.assertEquals((String)"There shouldn't be any namespace (solr special)", (Object)"{}TAG", (Object)tagFP.getFacetQName().toString());
        Assert.assertEquals((Object)"TagExtDisplayName", (Object)tagFP.getDisplayName());
        Assert.assertEquals((Object)"alfresco/search/FacetFilters", (Object)tagFP.getDisplayControl());
        Assert.assertEquals((long)3L, (long)tagFP.getMaxFilters());
        Assert.assertEquals((long)1L, (long)tagFP.getHitThreshold());
        Assert.assertEquals((long)2L, (long)tagFP.getMinFilterValueLength());
        Assert.assertEquals((Object)"DESCENDING", (Object)tagFP.getSortBy());
        Assert.assertEquals((Object)"ALL", (Object)tagFP.getScope());
        Assert.assertEquals((long)0L, (long)tagFP.getScopedSites().size());
        Assert.assertEquals((Object)true, (Object)tagFP.isEnabled());
        SolrFacetProperties creatorFP = (SolrFacetProperties)defaultProps.get("test_filter_creator");
        Assert.assertEquals((String)"Incorrect QNAME", (Object)"{http://www.alfresco.org/model/content/1.0}creator", (Object)creatorFP.getFacetQName().toString());
        String msg = "The value has not been overridden with the value from the custom properties";
        Assert.assertEquals((String)msg, (long)10L, (long)creatorFP.getMaxFilters());
        Assert.assertEquals((String)msg, (long)5L, (long)creatorFP.getHitThreshold());
        Assert.assertEquals((String)msg, (long)14L, (long)creatorFP.getMinFilterValueLength());
        Assert.assertEquals((String)msg, (long)1L, (long)creatorFP.getScopedSites().size());
        Assert.assertEquals((Object)"site1", creatorFP.getScopedSites().iterator().next());
    }

    @Test
    public void testOverrideOrder() throws Exception {
        ApplicationEvent applicationEvent = new ApplicationEvent(this){
            private static final long serialVersionUID = 1L;
        };
        SolrFacetConfig config = new SolrFacetConfig(rawProperties, "default,custom");
        config.setNamespaceService((NamespaceService)context.getBean("namespaceService", NamespaceService.class));
        config.onBootstrap(applicationEvent);
        SolrFacetProperties creatorFP = (SolrFacetProperties)config.getDefaultFacets().get("test_filter_creator");
        Assert.assertEquals((String)"Incorrect QNAME", (Object)"{http://www.alfresco.org/model/content/1.0}creator", (Object)creatorFP.getFacetQName().toString());
        Assert.assertEquals((long)10L, (long)creatorFP.getMaxFilters());
        Assert.assertEquals((long)5L, (long)creatorFP.getHitThreshold());
        Assert.assertEquals((long)14L, (long)creatorFP.getMinFilterValueLength());
        Assert.assertEquals((long)1L, (long)creatorFP.getScopedSites().size());
        Assert.assertEquals((Object)"site1", creatorFP.getScopedSites().iterator().next());
        config = new SolrFacetConfig(rawProperties, "custom,default");
        config.setNamespaceService((NamespaceService)context.getBean("namespaceService", NamespaceService.class));
        config.onBootstrap(applicationEvent);
        creatorFP = (SolrFacetProperties)config.getDefaultFacets().get("test_filter_creator");
        Assert.assertEquals((String)"Incorrect QNAME", (Object)"{http://www.alfresco.org/model/content/1.0}creator", (Object)creatorFP.getFacetQName().toString());
        Assert.assertEquals((long)5L, (long)creatorFP.getMaxFilters());
        Assert.assertEquals((long)1L, (long)creatorFP.getHitThreshold());
        Assert.assertEquals((long)4L, (long)creatorFP.getMinFilterValueLength());
        Assert.assertEquals((long)0L, (long)creatorFP.getScopedSites().size());
    }
}

