/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.alfresco.heartbeat.ConfigurationDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.mode.ServerMode;
import org.alfresco.repo.mode.ServerModeProvider;
import org.alfresco.repo.module.ModuleVersionNumber;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.usage.RepoUsageComponent;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleService;
import org.alfresco.service.cmr.repository.HBDataCollectorService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.webdav.WebDavService;
import org.alfresco.service.cmr.workflow.WorkflowAdminService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.traitextender.SpringExtensionBundle;
import org.apache.commons.dbcp2.BasicDataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ConfigurationDataCollectorTest {
    private ConfigurationDataCollector configurationCollector;
    private HBDataCollectorService mockCollectorService;
    private SpringExtensionBundle smartFoldersBundle;
    private DescriptorDAO mockDescriptorDAO;
    private DescriptorDAO mockServerDescriptorDAO;
    private List<HBData> collectedData;
    private HeartBeatJobScheduler mockScheduler;
    private static final ServerMode SERVER_MODE = ServerMode.PRODUCTION;
    private static final String INSTALLED_MODULE_ID_1 = "installedID1";
    private static final String INSTALLED_MODULE_ID_2 = "installedID2";
    private static final ModuleVersionNumber INSTALLED_MODULE_VERSION_1 = new ModuleVersionNumber("1.0");
    private static final ModuleVersionNumber INSTALLED_MODULE_VERSION_2 = new ModuleVersionNumber("2.0");
    private static final String MISSING_MODULE_ID_1 = "missingID1";
    private static final ModuleVersionNumber MISSING_MODULE_VERSION_1 = new ModuleVersionNumber("3.0");
    private static final String AUDIT_APP_NAME = "auditapp1";
    private static final boolean AUDIT_APP_ENABLED = true;

    @Before
    public void setUp() {
        this.smartFoldersBundle = (SpringExtensionBundle)Mockito.mock(SpringExtensionBundle.class);
        this.mockDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockServerDescriptorDAO = (DescriptorDAO)Mockito.mock(DescriptorDAO.class);
        this.mockCollectorService = (HBDataCollectorService)Mockito.mock(HBDataCollectorService.class);
        this.mockScheduler = (HeartBeatJobScheduler)Mockito.mock(HeartBeatJobScheduler.class);
        Descriptor mockDescriptor = (Descriptor)Mockito.mock(Descriptor.class);
        Mockito.when((Object)mockDescriptor.getId()).thenReturn((Object)"mock_id");
        Mockito.when((Object)this.mockServerDescriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        Mockito.when((Object)this.mockDescriptorDAO.getDescriptor()).thenReturn((Object)mockDescriptor);
        BasicDataSource mockBasicDataSource = (BasicDataSource)Mockito.mock(BasicDataSource.class);
        RepoUsageComponent mockRepoUsageComponent = (RepoUsageComponent)Mockito.mock(RepoUsageComponent.class);
        ServerModeProvider mockServerModeProvider = (ServerModeProvider)Mockito.mock(ServerModeProvider.class);
        Mockito.when((Object)mockServerModeProvider.getServerMode()).thenReturn((Object)SERVER_MODE);
        ChildApplicationContextFactory mockFileServerSubsystem = (ChildApplicationContextFactory)Mockito.mock(ChildApplicationContextFactory.class);
        WebDavService mockWebDavService = (WebDavService)Mockito.mock(WebDavService.class);
        ThumbnailService mockThumbnailService = (ThumbnailService)Mockito.mock(ThumbnailService.class);
        ChildApplicationContextFactory mockActivitiesFeedSubsystem = (ChildApplicationContextFactory)Mockito.mock(ChildApplicationContextFactory.class);
        WorkflowAdminService mockWorkflowAdminService = (WorkflowAdminService)Mockito.mock(WorkflowAdminService.class);
        ChildApplicationContextFactory mockInboundSMTPSubsystem = (ChildApplicationContextFactory)Mockito.mock(ChildApplicationContextFactory.class);
        ChildApplicationContextFactory mockImapSubsystem = (ChildApplicationContextFactory)Mockito.mock(ChildApplicationContextFactory.class);
        ChildApplicationContextFactory mockReplication = (ChildApplicationContextFactory)Mockito.mock(ChildApplicationContextFactory.class);
        ModuleService mockModuleService = (ModuleService)Mockito.mock(ModuleService.class);
        ModuleDetails mockInstalledModule1 = (ModuleDetails)Mockito.mock(ModuleDetails.class);
        Mockito.when((Object)mockInstalledModule1.getId()).thenReturn((Object)INSTALLED_MODULE_ID_1);
        Mockito.when((Object)mockInstalledModule1.getModuleVersionNumber()).thenReturn((Object)INSTALLED_MODULE_VERSION_1);
        ModuleDetails mockInstalledModule2 = (ModuleDetails)Mockito.mock(ModuleDetails.class);
        Mockito.when((Object)mockInstalledModule2.getId()).thenReturn((Object)INSTALLED_MODULE_ID_2);
        Mockito.when((Object)mockInstalledModule2.getModuleVersionNumber()).thenReturn((Object)INSTALLED_MODULE_VERSION_2);
        ModuleDetails mockMissingModule = (ModuleDetails)Mockito.mock(ModuleDetails.class);
        Mockito.when((Object)mockMissingModule.getId()).thenReturn((Object)MISSING_MODULE_ID_1);
        Mockito.when((Object)mockMissingModule.getModuleVersionNumber()).thenReturn((Object)MISSING_MODULE_VERSION_1);
        Mockito.when((Object)mockModuleService.getAllModules()).thenReturn(Arrays.asList(mockInstalledModule1, mockInstalledModule2));
        Mockito.when((Object)mockModuleService.getMissingModules()).thenReturn(Arrays.asList(mockMissingModule));
        AuditService mockAuditService = (AuditService)Mockito.mock(AuditService.class);
        AuditService.AuditApplication mockAuditApp = (AuditService.AuditApplication)Mockito.mock(AuditService.AuditApplication.class);
        Mockito.when((Object)mockAuditApp.isEnabled()).thenReturn((Object)true);
        HashMap<String, AuditService.AuditApplication> auditApps = new HashMap<String, AuditService.AuditApplication>();
        auditApps.put(AUDIT_APP_NAME, mockAuditApp);
        TransactionService mockTransactionService = (TransactionService)Mockito.mock(TransactionService.class);
        RetryingTransactionHelper mockRetryingTransactionHelper = (RetryingTransactionHelper)Mockito.mock(RetryingTransactionHelper.class);
        Mockito.when((Object)mockRetryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)true).thenReturn(auditApps);
        Mockito.when((Object)mockTransactionService.getRetryingTransactionHelper()).thenReturn((Object)mockRetryingTransactionHelper);
        DefaultChildApplicationContextManager mockAuthenticationSubsystem = (DefaultChildApplicationContextManager)Mockito.mock(DefaultChildApplicationContextManager.class);
        this.configurationCollector = new ConfigurationDataCollector("acs.repository.configuration", "1.0", "0 0 0 ? * SUN", this.mockScheduler);
        this.configurationCollector.setHbDataCollectorService(this.mockCollectorService);
        this.configurationCollector.setCurrentRepoDescriptorDAO(this.mockDescriptorDAO);
        this.configurationCollector.setSmartFoldersBundle(this.smartFoldersBundle);
        this.configurationCollector.setDataSource((DataSource)mockBasicDataSource);
        this.configurationCollector.setTransactionService(mockTransactionService);
        this.configurationCollector.setRepoUsageComponent(mockRepoUsageComponent);
        this.configurationCollector.setServerModeProvider(mockServerModeProvider);
        this.configurationCollector.setFileServersSubsystem(mockFileServerSubsystem);
        this.configurationCollector.setWebdavService(mockWebDavService);
        this.configurationCollector.setThumbnailService(mockThumbnailService);
        this.configurationCollector.setActivitiesFeedSubsystem(mockActivitiesFeedSubsystem);
        this.configurationCollector.setWorkflowAdminService(mockWorkflowAdminService);
        this.configurationCollector.setInboundSMTPSubsystem(mockInboundSMTPSubsystem);
        this.configurationCollector.setImapSubsystem(mockImapSubsystem);
        this.configurationCollector.setReplicationSubsystem(mockReplication);
        this.configurationCollector.setModuleService(mockModuleService);
        this.configurationCollector.setAuditService(mockAuditService);
        this.configurationCollector.setAuthenticationSubsystem(mockAuthenticationSubsystem);
        this.collectedData = this.configurationCollector.collectData();
    }

    @Test
    public void testHBDataFields() {
        for (HBData data : this.collectedData) {
            Assert.assertNotNull((Object)data.getCollectorId());
            Assert.assertNotNull((Object)data.getCollectorVersion());
            Assert.assertNotNull((Object)data.getSchemaVersion());
            Assert.assertNotNull((Object)data.getSystemId());
            Assert.assertNotNull((Object)data.getTimestamp());
            Assert.assertNotNull((Object)data.getData());
        }
    }

    @Test
    public void testConfigurationDataIsCollected() {
        HBData confData = this.grabDataByCollectorId(this.configurationCollector.getCollectorId());
        Assert.assertNotNull((String)"Repository configuration data missing.", (Object)confData);
        Map data = confData.getData();
        Assert.assertTrue((boolean)data.containsKey("smartFoldersEnabled"));
        Assert.assertTrue((boolean)data.containsKey("db"));
        Assert.assertTrue((boolean)((Map)data.get("db")).containsKey("maxConnections"));
        Assert.assertTrue((boolean)data.containsKey("serverReadOnly"));
        Assert.assertTrue((boolean)data.containsKey("serverMode"));
        Assert.assertTrue((boolean)data.containsKey("ftpEnabled"));
        Assert.assertTrue((boolean)data.containsKey("webDAVEnabled"));
        Assert.assertTrue((boolean)data.containsKey("thumbnailsEnabled"));
        Assert.assertTrue((boolean)data.containsKey("activitiesFeedEnabled"));
        Assert.assertTrue((boolean)data.containsKey("activitiEngineEnabled"));
        Assert.assertTrue((boolean)data.containsKey("inboundServerEnabled"));
        Assert.assertTrue((boolean)data.containsKey("imapEnabled"));
        Assert.assertTrue((boolean)data.containsKey("authenticationChain"));
        Assert.assertTrue((boolean)data.containsKey("replication"));
        Map replication = (Map)data.get("replication");
        Assert.assertTrue((boolean)replication.containsKey("enabled"));
        Assert.assertTrue((boolean)replication.containsKey("readOnly"));
        Assert.assertTrue((boolean)data.containsKey("module"));
        Map installedModules = (Map)((Map)data.get("module")).get("installed");
        Assert.assertTrue((installedModules != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)2, installedModules.get("count"));
        Map installedModulesList = (Map)installedModules.get("modules");
        Assert.assertTrue((boolean)installedModulesList.containsKey(INSTALLED_MODULE_ID_1));
        Map installedModulesInfo = (Map)installedModulesList.get(INSTALLED_MODULE_ID_1);
        Assert.assertTrue((boolean)installedModulesInfo.containsKey("version"));
        Assert.assertEquals((Object)INSTALLED_MODULE_VERSION_1.toString(), installedModulesInfo.get("version"));
        Assert.assertTrue((boolean)installedModulesList.containsKey(INSTALLED_MODULE_ID_2));
        installedModulesInfo = (Map)installedModulesList.get(INSTALLED_MODULE_ID_2);
        Assert.assertTrue((boolean)installedModulesInfo.containsKey("version"));
        Assert.assertEquals((Object)INSTALLED_MODULE_VERSION_2.toString(), installedModulesInfo.get("version"));
        Map missingModules = (Map)((Map)data.get("module")).get("missing");
        Assert.assertTrue((missingModules != null ? 1 : 0) != 0);
        Map missingModulesList = (Map)missingModules.get("modules");
        Assert.assertTrue((boolean)missingModulesList.containsKey(MISSING_MODULE_ID_1));
        Map missingModulesInfo = (Map)missingModulesList.get(MISSING_MODULE_ID_1);
        Assert.assertTrue((boolean)missingModulesInfo.containsKey("version"));
        Assert.assertEquals((Object)MISSING_MODULE_VERSION_1.toString(), missingModulesInfo.get("version"));
        Assert.assertTrue((boolean)data.containsKey("audit"));
        Assert.assertTrue((boolean)((Map)data.get("audit")).containsKey("enabled"));
        Map auditApps = (Map)((Map)data.get("audit")).get("apps");
        Assert.assertTrue((auditApps != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)auditApps.containsKey(AUDIT_APP_NAME));
        Map auditAppInfo = (Map)auditApps.get(AUDIT_APP_NAME);
        Assert.assertEquals((Object)true, auditAppInfo.get("enabled"));
    }

    private HBData grabDataByCollectorId(String collectorId) {
        for (HBData d : this.collectedData) {
            if (d.getCollectorId() == null || !d.getCollectorId().equals(collectorId)) continue;
            return d;
        }
        return null;
    }
}

