/*
 * #%L
 * Alfresco Repository
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.repo.template;

/**
 * Contract for Template API objects that support content on the 'cm:content' default property.
 * 
 * @author Kevin Roast
 */
public interface TemplateContent extends TemplateProperties
{
    /**
     * @return the content String for this node from the default content property (@see ContentModel.PROP_CONTENT)
     */
    public String getContent();

    /**
     * @return For a content document, this method returns the URL to the content stream for the default content property (@see ContentModel.PROP_CONTENT)
     *         <p>
     *         For a container node, this method return the URL to browse to the folder in the web-client
     */
    public String getUrl();

    /**
     * @return For a content document, this method returns the download URL to the content for the default content property (@see ContentModel.PROP_CONTENT)
     *         <p>
     *         For a container node, this method returns an empty string
     */
    public String getDownloadUrl();

    /**
     * @return The mimetype encoding for content attached to the node from the default content property (@see ContentModel.PROP_CONTENT)
     */
    public String getMimetype();

    /**
     * @return The size in bytes of the content attached to the node from the default content property (@see ContentModel.PROP_CONTENT)
     */
    public long getSize();
}
