/*
 * #%L
 * Alfresco Repository
 * %%
 * Copyright (C) 2005 - 2016 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.repo.dictionary;

import org.alfresco.service.cmr.dictionary.CustomModelException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/**
 * Validates model changes and deletes against the repository.
 * 
 * @author sglover
 *
 */
public interface ModelValidator
{
    /**
     * validate against dictionary
     * 
     * if new model then nothing to validate
     * 
     * else if an existing model then could be updated (or unchanged) so validate to currently only allow incremental updates - addition of new types, aspects (except default aspects), properties, associations - no deletion of types, aspects or properties or associations - no addition, update or deletion of default/mandatory aspects
     * 
     * @throws ModelInUseException
     *             if the model is being used by nodes or properties
     */
    void validateModel(CompiledModel compiledModel);

    /**
     * Can the model be deleted (validate against repository contents / workflows)?
     * 
     * @return true only if the model is not being used or if the model does not exist
     */
    boolean canDeleteModel(QName modelName);

    /**
     * validate the namespace prefix
     *
     * @throws CustomModelException
     *             if the prefix already exists in another model
     */
    void validateModelNamespacePrefix(NodeRef modelNodeRef);

}
