/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.ParameterizedItemImpl;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;

public abstract class BaseParameterizedItemImplTest
extends TestCase {
    protected List<ParameterDefinition> paramDefs = new ArrayList<ParameterDefinition>();
    protected Map<String, Serializable> paramValues = new HashMap<String, Serializable>();
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String TITLE = "title";
    protected static final String DESCRIPTION = "description";
    private static final String PARAM_1 = "param1";
    private static final String VALUE_1 = "value1";
    private static final String PARAM_2 = "param2";
    private static final String VALUE_2 = "value2";
    private static final String PARAM_DISPLAYLABEL = "displayLabel";

    protected void setUp() throws Exception {
        this.paramDefs.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_1, DataTypeDefinition.TEXT, false, PARAM_DISPLAYLABEL));
        this.paramDefs.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_2, DataTypeDefinition.TEXT, false, PARAM_DISPLAYLABEL));
        this.paramValues.put(PARAM_1, (Serializable)((Object)VALUE_1));
        this.paramValues.put(PARAM_2, (Serializable)((Object)VALUE_2));
    }

    public void testConstructor() {
        this.create();
    }

    protected abstract ParameterizedItemImpl create();

    public void testGetParameterValues() {
        ParameterizedItemImpl temp = this.create();
        Map tempParamValues = temp.getParameterValues();
        BaseParameterizedItemImplTest.assertNotNull((Object)tempParamValues);
        BaseParameterizedItemImplTest.assertEquals((int)2, (int)tempParamValues.size());
        for (Map.Entry entry : tempParamValues.entrySet()) {
            if (entry.getKey() == PARAM_1) {
                BaseParameterizedItemImplTest.assertEquals((Object)VALUE_1, entry.getValue());
                continue;
            }
            if (entry.getKey() == PARAM_2) {
                BaseParameterizedItemImplTest.assertEquals((Object)VALUE_2, entry.getValue());
                continue;
            }
            BaseParameterizedItemImplTest.fail((String)"There is an unexpected entry here.");
        }
    }

    public void testGetParameterValue() {
        ParameterizedItemImpl temp = this.create();
        BaseParameterizedItemImplTest.assertNull((Object)temp.getParameterValue("bobbins"));
        BaseParameterizedItemImplTest.assertEquals((Object)VALUE_1, (Object)temp.getParameterValue(PARAM_1));
    }

    public void testSetParameterValue() {
        ParameterizedItemImpl temp = this.create();
        temp.setParameterValue("bobbins", (Serializable)((Object)"value"));
        BaseParameterizedItemImplTest.assertEquals((Object)"value", (Object)temp.getParameterValue("bobbins"));
    }

    public void testGetId() {
        ParameterizedItemImpl temp = this.create();
        BaseParameterizedItemImplTest.assertEquals((String)ID, (String)temp.getId());
    }
}

