/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.registry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClient4Factory;
import org.alfresco.httpclient.HttpClientConfig;
import org.alfresco.repo.content.transform.LocalPassThroughTransform;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.transform.config.TransformConfig;
import org.alfresco.transform.config.Transformer;
import org.alfresco.transform.registry.AbstractTransformRegistry;
import org.alfresco.transform.registry.CombinedTransformConfig;
import org.alfresco.transform.registry.TransformServiceRegistryImpl;
import org.alfresco.util.ConfigFileFinder;
import org.apache.commons.logging.Log;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class CombinedConfig
extends CombinedTransformConfig {
    public static final String X_ALFRESCO_RETRY_NEEDED_HEADER = "X-Alfresco-Retry-Needed";
    private final Log log;
    private ObjectMapper jsonObjectMapper = new ObjectMapper();
    private ConfigFileFinder configFileFinder;
    private int tEngineCount;
    private final HttpClientConfig httpClientConfig;

    public CombinedConfig(Log log, final AbstractTransformRegistry registry, HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
        this.log = log;
        this.configFileFinder = new ConfigFileFinder(this.jsonObjectMapper){

            protected void readJson(JsonNode jsonNode, String readFrom, String baseUrl) {
                TransformConfig transformConfig = (TransformConfig)CombinedConfig.this.jsonObjectMapper.convertValue((Object)jsonNode, TransformConfig.class);
                CombinedConfig.this.addTransformConfig(transformConfig, readFrom, baseUrl, registry);
            }
        };
    }

    public boolean addLocalConfig(String path) {
        return this.configFileFinder.readFiles(path, this.log);
    }

    public boolean addRemoteConfig(List<String> urls, String remoteType) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpClient httpclient = HttpClient4Factory.createHttpClient((HttpClientConfig)this.httpClientConfig);){
            boolean successReadingConfig = true;
            for (String url : urls) {
                if (this.addRemoteConfig(httpclient, url, remoteType)) {
                    ++this.tEngineCount;
                    continue;
                }
                successReadingConfig = false;
            }
            return successReadingConfig;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean addRemoteConfig(CloseableHttpClient httpclient, String baseUrl, String remoteType) {
        boolean successReadingConfig;
        block29: {
            String url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "/transform/config?configVersion=2";
            HttpGet httpGet = new HttpGet(url);
            successReadingConfig = true;
            try {
                try {
                    Throwable throwable = null;
                    Object var8_11 = null;
                    try (CloseableHttpResponse response = this.execute(httpclient, httpGet);){
                        StatusLine statusLine = response.getStatusLine();
                        if (statusLine == null) {
                            throw new AlfrescoRuntimeException(remoteType + " on " + url + " returned no status ");
                        }
                        HttpEntity resEntity = response.getEntity();
                        if (resEntity != null) {
                            int statusCode = statusLine.getStatusCode();
                            if (statusCode == 200) {
                                try {
                                    String content = this.getContent(resEntity);
                                    Throwable throwable2 = null;
                                    Object var15_22 = null;
                                    try (StringReader reader = new StringReader(content);){
                                        int transformCount = this.transformerCount();
                                        this.configFileFinder.readFile((Reader)reader, remoteType + " on " + baseUrl, "json", baseUrl, this.log);
                                        if (transformCount == this.transformerCount() || response.containsHeader(X_ALFRESCO_RETRY_NEEDED_HEADER)) {
                                            successReadingConfig = false;
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                    EntityUtils.consume((HttpEntity)resEntity);
                                    break block29;
                                }
                                catch (IOException e) {
                                    throw new AlfrescoRuntimeException("Failed to read the returned content from " + remoteType + " on " + url, (Throwable)e);
                                }
                            }
                            String message = this.getErrorMessage(resEntity);
                            throw new AlfrescoRuntimeException(remoteType + " on " + url + " returned a " + statusCode + " status " + message);
                        }
                        throw new AlfrescoRuntimeException(remoteType + " on " + url + " did not return an entity " + url);
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new AlfrescoRuntimeException("Failed to connect or to read the response from " + remoteType + " on " + url, (Throwable)e);
                }
            }
            catch (AlfrescoRuntimeException e) {
                this.log.error((Object)e.getMessage());
                successReadingConfig = false;
            }
        }
        return successReadingConfig;
    }

    CloseableHttpResponse execute(CloseableHttpClient httpclient, HttpGet httpGet) throws IOException {
        return httpclient.execute((HttpUriRequest)httpGet);
    }

    String getContent(HttpEntity resEntity) throws IOException {
        return EntityUtils.toString((HttpEntity)resEntity);
    }

    private String getErrorMessage(HttpEntity resEntity) throws IOException {
        int j;
        String message = "";
        String content = this.getContent(resEntity);
        int i = content.indexOf("\"message\":\"");
        if (i != -1 && (j = content.indexOf("\",\"path\":", i)) != -1) {
            message = content.substring(i + 11, j);
        }
        return message;
    }

    protected boolean isPassThroughTransformName(String name) {
        return name.equals("PassThrough");
    }

    public void addPassThroughTransformer(MimetypeService mimetypeService, AbstractTransformRegistry registry) {
        List mimetypes = mimetypeService.getMimetypes();
        Transformer transformer = LocalPassThroughTransform.getConfig(mimetypes);
        TransformConfig transformConfig = TransformConfig.builder().withTransformers(Collections.singletonList(transformer)).build();
        this.addTransformConfig(transformConfig, "based on mimetype list", null, registry);
    }

    public void register(TransformServiceRegistryImpl registry) {
        TransformServiceRegistryImpl.Data data = registry.getData();
        data.setTEngineCount(this.tEngineCount);
        data.setFileCount(this.configFileFinder.getFileCount());
        this.combineTransformerConfig(registry);
        this.registerCombinedTransformers(registry);
    }
}

