/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet.facetsresponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.solr.facet.facetsresponse.Metric;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;

public class ListMetric
implements Metric {
    private static Log logger = LogFactory.getLog(ListMetric.class);
    private final Metric.METRIC_TYPE type;
    private final Map<String, Object> value = new HashMap<String, Object>(1);

    public ListMetric(Metric.METRIC_TYPE type, Object val) {
        this.type = type;
        try {
            JSONArray jsonArray = (JSONArray)val;
            ArrayList<Object> values = new ArrayList<Object>(jsonArray.length());
            int i = 0;
            while (i < jsonArray.length()) {
                values.add(jsonArray.get(i));
                ++i;
            }
            this.value.put(type.toString(), values);
        }
        catch (ClassCastException classCastException) {
            logger.debug((Object)("ClassCastException for " + String.valueOf(val)));
        }
        catch (JSONException e) {
            logger.debug((Object)("Failed to process " + String.valueOf(val) + " " + e.getMessage()));
        }
    }

    @Override
    public Metric.METRIC_TYPE getType() {
        return this.type;
    }

    @Override
    public Map<String, Object> getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListMetric that = (ListMetric)o;
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

