/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.rawevents.types.OnContentUpdatePolicyEvent;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenditionEventProcessor
implements Processor {
    private static Log logger = LogFactory.getLog(RenditionEventProcessor.class);
    private RenditionService2Impl renditionService2;
    private ObjectMapper messagingObjectMapper;
    private TransactionService transactionService;

    public void setRenditionService2(RenditionService2Impl renditionService2) {
        this.renditionService2 = renditionService2;
    }

    public void setMessagingObjectMapper(ObjectMapper messagingObjectMapper) {
        this.messagingObjectMapper = messagingObjectMapper;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void process(Exchange exchange) throws Exception {
        String body = (String)exchange.getMessage().getBody();
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Processing message [thread=" + Thread.currentThread().getId() + ", body=" + body + "]"));
        }
        if (body == null || body.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exchange message is null or empty");
            }
            return;
        }
        try {
            OnContentUpdatePolicyEvent event;
            try {
                event = (OnContentUpdatePolicyEvent)this.messagingObjectMapper.readValue(body, OnContentUpdatePolicyEvent.class);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to unmarshal event [" + body + "]"), (Throwable)e);
                throw new AlfrescoRuntimeException("Failed to unmarshal event, skipping processing of this event.\"");
            }
            this.processEvent(event);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to process on content update raw event: " + body), (Throwable)e);
        }
    }

    private void validateEvent(OnContentUpdatePolicyEvent event) {
        ParameterCheck.mandatory((String)"event", (Object)event);
        ParameterCheck.mandatoryString((String)"nodeRef", (String)event.getNodeRef());
    }

    private String getExecutingUserOrDefault(OnContentUpdatePolicyEvent event) {
        if (event.getExecutingUser() != null && !event.getExecutingUser().isEmpty()) {
            return event.getExecutingUser();
        }
        return AuthenticationUtil.getSystemUserName();
    }

    private void processEvent(OnContentUpdatePolicyEvent event) {
        this.validateEvent(event);
        String executingUser = this.getExecutingUserOrDefault(event);
        AuthenticationUtil.runAs(() -> this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
            this.renditionService2.onContentUpdate(new NodeRef(event.getNodeRef()), event.isNewContent());
            return null;
        }), (String)executingUser);
    }
}

