/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.alfresco.repo.virtual.ref.NodeRefRadixHasher;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class NodeRefRadixHasherTest {
    private final NodeRefRadixHasher nodeRefRadixHasher;

    @Parameterized.Parameters(name="radix: {0}")
    public static Collection<Object[]> data() {
        return List.of(new Object[]{NodeRefRadixHasher.RADIX_36_HASHER}, new Object[]{new NodeRefRadixHasher()}, new Object[]{new NodeRefRadixHasher(32)});
    }

    public NodeRefRadixHasherTest(NodeRefRadixHasher nodeRefRadixHasher) {
        this.nodeRefRadixHasher = nodeRefRadixHasher;
    }

    @Test
    public void testSupportedStoresWithRandomUuids() {
        List<String> storeProtocols = List.of("workspace", "archive", "avm", "deleted", "versionStore");
        List<String> storeIds = List.of("SpacesStore", "lightWeightVersionStore", "version2Store");
        List<String> uuidNodeIds = Stream.generate(UUID::randomUUID).map(UUID::toString).limit(5L).toList();
        for (String storeProtocol : storeProtocols) {
            for (String storeId : storeIds) {
                for (String uuidNodeId : uuidNodeIds) {
                    NodeRef nodeRef = new NodeRef(storeProtocol, storeId, uuidNodeId);
                    Pair hash = this.nodeRefRadixHasher.hash(nodeRef);
                    Assert.assertFalse((boolean)((String)hash.getSecond()).startsWith("X"));
                    NodeRef actualNodeRef = this.nodeRefRadixHasher.lookup(hash);
                    Assert.assertEquals((Object)nodeRef, (Object)actualNodeRef);
                }
            }
        }
    }

    @Test
    public void testSpecificValidNotUuidNodeIds() {
        StoreRef storeRef = new StoreRef("workspace", "lightWeightVersionStore");
        List<String> notUuidNodeIds = List.of("0d3b26ff-c4c1-4680-8622-8608ea7ab4", "0d3b26ff-c4c14680-8622-8608ea7ab4b29", "wf-email-html-ftl", "a", "X", "defrobldkfoeirjtuy79dfwwqperfiidoelb");
        for (String notUuidNodeId : notUuidNodeIds) {
            NodeRef nodeRef = new NodeRef(storeRef, notUuidNodeId);
            Pair hash = this.nodeRefRadixHasher.hash(nodeRef);
            Assert.assertTrue((boolean)((String)hash.getSecond()).startsWith("X"));
            NodeRef actualNodeRef = this.nodeRefRadixHasher.lookup(hash);
            Assert.assertEquals((Object)nodeRef, (Object)actualNodeRef);
        }
    }

    @Test(expected=RuntimeException.class)
    public void testEmptyNodeId() {
        NodeRef nodeRef = new NodeRef("workspace://SpacesStore/");
        this.nodeRefRadixHasher.hash(nodeRef);
    }
}

