/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryEngine;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSet;
import org.alfresco.repo.search.impl.querymodel.impl.db.NodePermissionAssessor;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.Pair;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mybatis.spring.SqlSessionTemplate;

public class DBQueryEngineTest {
    private static final String SQL_TEMPLATE_PATH = "alfresco.metadata.query.select_byDynamicQuery";
    private DBQueryEngine engine;
    private SqlSessionTemplate template;
    private NodePermissionAssessor assessor;
    private DBQuery dbQuery;
    private ResultContext<Node> resultContext;
    private QueryOptions options;
    private NodeDAO nodeDAO;

    @Before
    public void setup() {
        this.engine = new DBQueryEngine();
        this.assessor = (NodePermissionAssessor)Mockito.mock(NodePermissionAssessor.class);
        this.dbQuery = (DBQuery)Mockito.mock(DBQuery.class);
        this.resultContext = (ResultContext)Mockito.spy((Object)new DefaultResultContext());
        this.options = this.createQueryOptions();
        this.template = (SqlSessionTemplate)Mockito.mock(SqlSessionTemplate.class);
        this.engine.setSqlSessionTemplate(this.template);
        this.engine.nodesCache = (EntityLookupCache)Mockito.mock(EntityLookupCache.class);
        this.nodeDAO = (NodeDAO)Mockito.mock(NodeDAO.class);
        this.engine.setNodeDAO(this.nodeDAO);
        this.mockStores();
    }

    @Test
    public void shouldGetAFilteringResultSetFromAcceleratedNodeSelection() {
        this.withMaxItems(10);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertTrue((boolean)(result instanceof FilteringResultSet));
    }

    @Test
    public void shouldResultSetHaveExpectedAmountOfRequiredNodesBasedOnMaxItems() {
        this.withMaxItems(5);
        this.prepareTemplate(this.dbQuery, this.createNodes(20));
        Mockito.when((Object)this.assessor.isIncluded((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertEquals((long)6L, (long)result.length());
        this.assertNodePresent(0L, result);
        this.assertNodePresent(1L, result);
        this.assertNodePresent(2L, result);
        this.assertNodePresent(3L, result);
        this.assertNodePresent(4L, result);
    }

    @Test
    public void shouldResultContextBeClosedWhenMaxItemsReached() {
        this.withMaxItems(5);
        this.prepareTemplate(this.dbQuery, this.createNodes(20));
        Mockito.when((Object)this.assessor.isIncluded((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        ((ResultContext)Mockito.verify(this.resultContext)).stop();
        Assert.assertEquals((long)6L, (long)result.length());
    }

    @Test
    public void shouldResultSetHaveCorrectAmountOfRequiredNodesWhenSkipCountIsUsed() {
        this.withMaxItems(5);
        this.withSkipCount(10);
        this.prepareTemplate(this.dbQuery, this.createNodes(20));
        Mockito.when((Object)this.assessor.isIncluded((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertEquals((long)6L, (long)result.length());
        this.assertNodePresent(10L, result);
        this.assertNodePresent(11L, result);
        this.assertNodePresent(12L, result);
        this.assertNodePresent(13L, result);
        this.assertNodePresent(14L, result);
    }

    @Test
    public void shouldResultSetHaveCorrectAmountOfRequiredNodesWhenSomeAreExcludedDueToDeclinedPermission() {
        this.withMaxItems(5);
        List<Node> nodes = this.createNodes(20);
        Mockito.when((Object)this.assessor.isIncluded((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        Mockito.when((Object)this.assessor.isIncluded(nodes.get(0))).thenReturn((Object)false);
        Mockito.when((Object)this.assessor.isIncluded(nodes.get(1))).thenReturn((Object)false);
        Mockito.when((Object)this.assessor.isIncluded(nodes.get(2))).thenReturn((Object)false);
        this.prepareTemplate(this.dbQuery, nodes);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertEquals((long)6L, (long)result.length());
        this.assertNodePresent(3L, result);
        this.assertNodePresent(4L, result);
        this.assertNodePresent(5L, result);
        this.assertNodePresent(6L, result);
        this.assertNodePresent(7L, result);
    }

    @Test
    public void shouldResultSetLengthMatchTheAmountOfAllAccessibleNodesWhenMaxPermissionCheckEnabled() {
        this.withMaxItems(5);
        this.prepareTemplate(this.dbQuery, this.createNodes(10));
        Mockito.when((Object)this.assessor.isIncluded((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        this.engine.setMaxPermissionCheckEnabled(true);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertEquals((long)10L, (long)result.length());
    }

    @Test
    public void shouldNotConsiderInaccessibleNodesInResultSetWhenSkippingNodes() {
        this.withMaxItems(2);
        this.withSkipCount(2);
        List<Node> nodes = this.createNodes(6);
        Mockito.when((Object)this.assessor.isIncluded((Node)ArgumentMatchers.any(Node.class))).thenReturn((Object)true);
        Mockito.when((Object)this.assessor.isIncluded(nodes.get(2))).thenReturn((Object)false);
        Mockito.when((Object)this.assessor.isIncluded(nodes.get(3))).thenReturn((Object)false);
        this.prepareTemplate(this.dbQuery, nodes);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertEquals((long)2L, (long)result.length());
        this.assertNodePresent(4L, result);
        this.assertNodePresent(5L, result);
    }

    @Test
    public void shouldQuitCheckingNodePermissionsWhenImposedLimitsAreReached() {
        this.prepareTemplate(this.dbQuery, this.createNodes(20));
        Mockito.when((Object)this.assessor.shouldQuitChecks()).thenReturn((Object)true);
        FilteringResultSet result = this.engine.acceleratedNodeSelection(this.options, this.dbQuery, this.assessor);
        Assert.assertEquals((long)0L, (long)result.length());
        ((ResultContext)Mockito.verify(this.resultContext)).stop();
    }

    private void prepareTemplate(DBQuery dbQuery, List<Node> nodes) {
        ((SqlSessionTemplate)Mockito.doAnswer(invocation -> {
            ResultHandler handler = (ResultHandler)invocation.getArgument(2);
            for (Node node : nodes) {
                if (this.resultContext.isStopped()) continue;
                Mockito.when((Object)((Node)this.resultContext.getResultObject())).thenReturn((Object)node);
                handler.handleResult(this.resultContext);
            }
            return null;
        }).when((Object)this.template)).select((String)ArgumentMatchers.eq((Object)SQL_TEMPLATE_PATH), ArgumentMatchers.eq((Object)dbQuery), (ResultHandler)ArgumentMatchers.any());
    }

    private QueryOptions createQueryOptions() {
        QueryOptions options = (QueryOptions)Mockito.mock(QueryOptions.class);
        SearchParameters searchParams = (SearchParameters)Mockito.mock(SearchParameters.class);
        Mockito.when((Object)options.getAsSearchParmeters()).thenReturn((Object)searchParams);
        return options;
    }

    private void assertNodePresent(long id, FilteringResultSet result) {
        DBResultSet rs = (DBResultSet)result.getUnFilteredResultSet();
        int i = 0;
        while (i < rs.length()) {
            if (rs.getNode(i).getId().equals(id)) {
                return;
            }
            ++i;
        }
        Assert.fail((String)("Node with id " + id + " was not found in the result set"));
    }

    private void withMaxItems(int maxItems) {
        Mockito.when((Object)this.options.getMaxItems()).thenReturn((Object)maxItems);
    }

    private void withSkipCount(int skipCount) {
        Mockito.when((Object)this.options.getSkipCount()).thenReturn((Object)skipCount);
    }

    private List<Node> createNodes(int amount) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        int i = 0;
        while (i < amount) {
            nodes.add(this.createNode(i));
            ++i;
        }
        return nodes;
    }

    private Node createNode(int id) {
        Node node = (Node)Mockito.spy(Node.class);
        Mockito.when((Object)node.getId()).thenReturn((Object)id);
        StoreEntity store = (StoreEntity)Mockito.mock(StoreEntity.class);
        Mockito.when((Object)node.getStore()).thenReturn((Object)store);
        return node;
    }

    private void mockStores() {
        Pair spacesStore = new Pair((Object)6L, (Object)new StoreRef("workspace://SpacesStore"));
        List<Pair> stores = Arrays.asList(spacesStore);
        Mockito.when((Object)this.nodeDAO.getStores()).thenReturn(stores);
    }
}

